

<?php $__env->startSection('title'); ?>
    <?php echo e(__('Login')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('main_content'); ?>
    <div class="loging-header">
        <div class="footer-logo">
            <img src="<?php echo e(asset(get_option('general')['login_page_logo'] ?? 'assets/images/login/login-logo.svg')); ?>" alt="logo">
        </div>

        <?php if(moduleCheck('RestaurantOnlineStore')): ?>
        <?php
        $business = get_business();
        ?>
        <div class="login-stor-btn">
            <a href="<?php echo e(route('onlineStore.index', ['restaurant_slug' => $business->slug ])); ?>">Online Store</a>
        </div>
        <?php endif; ?>
    </div>
    <div class="footer position-relative">
        <div class="mybazar-login-section ">
            <div class="mybazar-login-wrapper ">
                <div class="login-wrapper">
                    <div class="login-body w-100">
                        <h2 class="login-title"><?php echo e(__('Welcome to')); ?> <?php echo e(__(env('APP_NAME'))); ?></h2>
                        <form method="POST" action="<?php echo e(route('login')); ?>" class="ajaxform_instant_reload">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="fcm_token" id="fcm_token">
                            <div class="input-group ">
                                <span class="input-icon"><img src="<?php echo e(asset('assets/images/icons/email.svg')); ?>" alt="img"></span>
                                <input type="text" name="email" class="form-control w-100 dynamictext" placeholder="<?php echo e(__('Enter your Email')); ?>">
                            </div>

                            <div class="input-group">
                                <span class="input-icon"><img src="<?php echo e(asset('assets/images/icons/lock.svg')); ?>" alt="img"></span>

                                <span class="hide-pass">
                                    <img src="<?php echo e(asset('assets/images/icons/show.svg')); ?>" alt="img">
                                    <img src="<?php echo e(asset('assets/images/icons/Hide.svg')); ?>" alt="img">
                                </span>
                                <input type="password" name="password" class="form-control w-100 password" placeholder="<?php echo e(__('Password')); ?>">
                            </div>

                            <div class="mt-lg-3 mb-0 forget-password">
                                <label class="custom-control-label">
                                    <input type="checkbox" name="remember" class="custom-control-input">
                                    <span><?php echo e(__('Remember me')); ?></span>
                                </label>
                                <a href="<?php echo e(route('password.request')); ?>"><?php echo e(__('Forgot Password?')); ?></a>
                            </div>

                            <button type="submit" class="btn login-btn submit-btn"><?php echo e(__('Log In')); ?></button>


                            <div class="d-flex justify-content-between">
                                <a class="backhome" href="<?php echo e(url('/')); ?>"><?php echo e(__('Back Home')); ?></a>
                                <a class="backhome" data-bs-toggle="modal" data-bs-target="#registration-modal"><?php echo e(__('Create an Account')); ?></a>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="login-img">
                    <img src="<?php echo e(asset(get_option('general')['login_page_img'] ?? 'assets/images/login/login-img.svg')); ?>"
                        alt="">
                </div>
            </div>
        </div>
    </div>
    <input type="hidden" data-model="Login" id="auth">
<?php $__env->stopSection(); ?>

<?php $__env->startPush('modal'); ?>
    <?php echo $__env->make('web.components.signup', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
    <script src="<?php echo e(asset('assets/js/auth.js')); ?>?v=<?php echo e(time()); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.auth.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH H:\Xampp\htdocs\restaurant_app_admin_codecanyon_update\resources\views/auth/login.blade.php ENDPATH**/ ?>