<div class="modal fade" id="registration-modal">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5"><?php echo e(__('Create A')); ?> <span id="subscription_name"> <?php echo e(__('Free')); ?></span>
                    <?php echo e(__('Account')); ?></h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="personal-info">
                    <form id="registration-form" action="<?php echo e(route('register')); ?>" method="post"
                        enctype="multipart/form-data" class="add-brand-form pt-0 sign_up_form">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="mt-3 col-lg-6">
                                <label class="custom-top-label"><?php echo e(__('Company/Business Name')); ?></label>
                                <input type="text" name="companyName"
                                    placeholder="<?php echo e(__('Enter business/store Name')); ?>" class="form-control" required />
                            </div>
                            <div class="mt-3 col-lg-6">
                                <label class="custom-top-label"><?php echo e(__('Business Category')); ?></label>
                                <div class="gpt-up-down-arrow position-relative">
                                    <select name="business_category_id"
                                        class="form-control form-selected business_category" required>
                                        <?php $__currentLoopData = $business_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <span></span>
                                </div>
                            </div>

                            <div class="mt-3 col-lg-6">
                                <label class="custom-top-label"><?php echo e(__('Phone')); ?></label>
                                <input type="number" name="phoneNumber" placeholder="<?php echo e(__('Enter Phone Number')); ?>"
                                    class="form-control" required />
                            </div>
                            <div class="mt-3 col-lg-6">
                                <label class="custom-top-label"><?php echo e(__('Email Address')); ?></label>
                                <input type="email" name="email" placeholder="<?php echo e(__('Enter Email Address')); ?>"
                                    class="form-control" required />
                            </div>
                            <div class="mt-3 col-lg-6">
                                <label class="custom-top-label"><?php echo e(__('Password')); ?></label>
                                <input type="password" name="password" placeholder="<?php echo e(__('Enter Password')); ?>"
                                    class="form-control" required />
                            </div>
                            <div class="mt-3 col-lg-6">
                                <label class="custom-top-label"><?php echo e(__('Company Address')); ?></label>
                                <input type="text" name="address" placeholder="<?php echo e(__('Enter Company Address')); ?>"
                                    class="form-control" />
                            </div>
                            <div class="mt-3 col-lg-12">
                                <label class="custom-top-label"><?php echo e(__('Opening Balance')); ?></label>
                                <input type="number" name="shopOpeningBalance"
                                    placeholder="<?php echo e(__('Enter Opening Balance')); ?>" class="form-control" />
                            </div>
                        </div>

                        <div class="offcanvas-footer mt-3 d-flex justify-content-center gap-2">
                            <button type="button" data-bs-dismiss="modal" class="cancel-btn "
                                data-bs-dismiss="offcanvas" aria-label="Close">
                                <?php echo e(__('Close')); ?>

                            </button>
                            <button class="submit-btn" type="submit">
                                <?php echo e(__('Save')); ?>

                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!--Verify Modal Start -->
<div class="modal fade" id="verifymodal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
    aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content verify-content">
            <div class="modal-header border-bottom-0">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body verify-modal-body  text-center">

                <h4 class="mb-0 verification-title"><?php echo e(__('Email Verification')); ?></h4>
                <p class="des p-8-0 pb-3"><?php echo e(__('we sent an OTP in your email address')); ?> <br>
                    <span id="dynamicEmail"></span>
                </p>
                <form action="<?php echo e(route('otp-submit')); ?>" method="post" class="verify_form">
                    <?php echo csrf_field(); ?>
                    <div class="code-input pin-container">
                        <input class="pin-input otp-input" id="pin-1" type="number" name="otp[]" maxlength="1">
                        <input class="pin-input otp-input" id="pin-2" type="number" name="otp[]" maxlength="1">
                        <input class="pin-input otp-input" id="pin-3" type="number" name="otp[]" maxlength="1">
                        <input class="pin-input otp-input" id="pin-4" type="number" name="otp[]" maxlength="1">
                        <input class="pin-input otp-input" id="pin-5" type="number" name="otp[]" maxlength="1">
                        <input class="pin-input otp-input" id="pin-6" type="number" name="otp[]" maxlength="1">
                    </div>

                    <p class="des p-24-0 pt-2">
                        <?php echo e(__('Code send in')); ?> <span id="countdown" class="countdown"></span>
                        <span class="reset text-primary cursor-pointer" id="otp-resend" data-route="<?php echo e(route('otp-resend')); ?>"><?php echo e(__('Resend code')); ?></span>
                    </p>
                    <button class="verify-btn btn submit-btn ps-custom-btn mt-2"><?php echo e(__('Verify')); ?></button>
                </form>
            </div>
        </div>
    </div>
</div>
<!--Verify Modal end -->

<!-- success Modal Start -->
<div class="modal fade" id="successmodal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
    aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content success-content">
            <div class="modal-header border-bottom-0">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body success-modal-body text-center">
                <div>
                    <img src="<?php echo e(asset('assets/img/icon/success-icon.svg')); ?>" alt="success">
                    <h4><?php echo e(__('Successfully!')); ?></h4>
                    <p class="mb-3"><?php echo e(__('Congratulations, Your account has been')); ?> <br> <?php echo e(__('successfully created')); ?></p>
                    <a href="<?php echo e(get_option('general')['app_link'] ?? ''); ?>" target="_blank" class="download-btn mb-2"><?php echo e(__('Download Apk')); ?> </a>
                </div>
            </div>
        </div>
    </div>
</div>
<!--success Modal end -->
<?php /**PATH H:\Xampp\htdocs\restaurant_app_admin_codecanyon_update\resources\views/web/components/signup.blade.php ENDPATH**/ ?>