@extends('layouts.master')

@section('title')
    {{ __('Edit Store') }}
@endsection

@section('main_content')
    <div class="erp-table-section">
        <div class="container-fluid">
            <div class="card border-0">
                <div class="card-bodys">
                    <div class="table-header p-16">
                        <h4>{{ __('Edit Store') }}</h4>
                        @can('business-read')
                            <a href="{{ route('admin.business.index') }}" class="add-order-btn rounded-2">
                                <i class="far fa-list" aria-hidden="true"></i>
                                {{ __('Store List') }}
                            </a>
                        @endcan
                    </div>
                    <div class="order-form-section p-16">
                        <form action="{{ route('admin.business.update', $business->id) }}" method="POST"
                            class="ajaxform_instant_reload">
                            @csrf
                            @method('PUT')
                            <div class="add-suplier-modal-wrapper d-block">
                                <div class="row">

                                    <div class="col-lg-6 mb-2">
                                        <label>{{ __('Store Name') }}</label>
                                        <input type="text" name="companyName" value="{{ $business->companyName }}" required class="form-control" placeholder="{{ __('Enter Business Name') }}">
                                    </div>

                                    <div class="col-lg-6 mb-2">
                                        <label>{{ __('Category') }}</label>
                                        <div class="gpt-up-down-arrow position-relative">
                                            <select name="business_category_id" required
                                                class="form-control table-select choices-select w-100 role">
                                                <option value=""> {{ __('Select Category') }}</option>
                                                @foreach ($categories as $category)
                                                    <option @selected($category->id == $business->business_category_id) value="{{ $category->id }}">
                                                        {{ ucfirst($category->name) }} </option>
                                                @endforeach
                                            </select>
                                            <span></span>
                                        </div>
                                    </div>

                                    <div class="col-lg-6 mb-2">
                                        <label>{{ __('Subscription Plan') }}</label>
                                        <div class="gpt-up-down-arrow position-relative">
                                            <select name="plan_subscribe_id" class="form-control choices-select table-select w-100 role">
                                                <option value="">{{ __('Select One') }}</option>
                                                @foreach ($plans as $plan)
                                                    <option @selected($plan->id == $business->plan_subscribe_id) value="{{ $plan->id }}">
                                                        {{ ucfirst($plan->subscriptionName) }}
                                                    </option>
                                                @endforeach
                                            </select>
                                            <span></span>
                                        </div>
                                    </div>

                                    <div class="col-lg-6 mb-2">
                                        <label>{{ __('Phone') }}</label>
                                        <input type="text" name="phoneNumber" value="{{ $business->phoneNumber }}" required class="form-control" placeholder="{{ __('Enter Phone Number') }}">
                                    </div>

                                    <div class="col-lg-6 mb-2">
                                        <label>{{ __('Email') }}</label>
                                        <input type="email" name="email" value="{{ $user->email }}"
                                            class="form-control" placeholder="{{ __('Enter Email') }}">
                                    </div>

                                    <div class="col-lg-6 mb-2">
                                        <label>{{ __('Shop Opening Balance') }}</label>
                                        <input type="number" name="shopOpeningBalance"
                                            value="{{ $business->shopOpeningBalance }}" required class="form-control"
                                            placeholder="{{ __('Enter Balance') }}">
                                    </div>

                                    <div class="col-lg-6 mb-2">
                                        <label>{{ __('Address') }}</label>
                                        <input type="text" name="address" value="{{ $business->address }}" required
                                            class="form-control" placeholder="{{ __('Enter Address') }}">
                                    </div>

                                    <div class="col-lg-6">
                                        <label>{{__('Password')}}</label>
                                        <div class="pass-field">
                                            <input type="password" name="password" class="form-control" placeholder="{{ __('Enter Password') }}">
                                            <i class="far fa-eye eye-btn"></i>
                                        </div>
                                    </div>

                                    <div class="col-lg-6">
                                        <div class="row align-items-center justify-content-center">
                                            <div class="col-10">
                                                <label class="img-label">{{ __('Image') }}</label>
                                                <input type="file" accept="image/*" name="pictureUrl"
                                                    class="form-control file-input-change" data-id="image">
                                            </div>
                                            <div class="col-2 mt-4">
                                                <img src="{{ asset($business->pictureUrl ?? 'assets/img/icon/upload.png') }}"
                                                    id="image" class="table-img">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-lg-12">
                                        <div class="button-group text-center mt-3">
                                            <a href="{{ route('admin.business.index') }}" class="theme-btn border-btn m-2">{{ __('Cancel') }}</a>
                                            <button class="theme-btn m-2 submit-btn">{{ __('Save') }}</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
