@foreach ($businesses as $business)
    <tr class="table-content">
        <td class="w-60 checkbox table-single-content d-print-none">
            <label class="table-custom-checkbox">
                <input type="checkbox" name="ids[]" class="table-hidden-checkbox checkbox-item delete-checkbox-item multi-delete"
                    value="{{ $business->id }}">
                <span class="table-custom-checkmark custom-checkmark"></span>
            </label>
        </td>

        <td class="table-single-content text-start">{{ $businesses->perPage() * ($businesses->currentPage() - 1) + $loop->iteration }} <i class="{{ request('id') == $business->id ? 'fas fa-bell text-red' : '' }}"></i></td>
        <td class="table-single-content">{{ $business->companyName }}</td>
        <td class="table-single-content d-print-none">{{ $business->category->name ?? '' }}</td>
        <td class="table-single-content">{{ $business->phoneNumber }}</td>
        <td class="table-single-content">{{ $business->enrolled_plan?->plan?->subscriptionName }}</td>
        <td class="table-single-content d-print-none">{{ formatted_date($business->subscriptionDate) }}</td>
        <td class="table-single-content">{{ formatted_date($business->will_expire) }}</td>
        <td class="text-center table-single-content d-print-none">
        <label class="switch">
            <input type="checkbox" {{ $business->status == 1 ? 'checked' : '' }} class="status" data-url="{{ route('admin.business.status', $business->id) }}">
            <span class="slider round"></span>
        </label>
        </td>
        <td class="print-d-none table-single-content d-print-none">
            <div class="dropdown table-action">
                <button type="button" data-bs-toggle="dropdown">
                    <i class="far fa-ellipsis-v"></i>
                </button>
                <ul class="dropdown-menu">
                    <li>
                        <a href="#business-upgrade-modal" class="business-upgrade-plan" data-bs-toggle="modal"
                            data-id="{{ $business->id }}" data-name="{{ $business->companyName }}" data-url="{{ route('admin.business.upgrade.plan', $business->id) }}">
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M15.7466 6.19842L15.4807 5.93342C15.429 5.88092 15.3991 5.81096 15.3991 5.73679V5.36346C15.3991 4.02429 14.3091 2.93426 12.9699 2.93426H12.5966C12.5233 2.93426 12.4515 2.90422 12.3999 2.85339L12.135 2.58758C11.1883 1.64091 9.64743 1.63924 8.6991 2.58758L8.4342 2.85257C8.38254 2.90424 8.3108 2.93426 8.23747 2.93426H7.86413C6.52497 2.93426 5.43493 4.02429 5.43493 5.36346V5.73679C5.43493 5.81096 5.40585 5.88094 5.35335 5.93261L5.08744 6.19923C4.14077 7.1459 4.14077 8.6876 5.08744 9.6351L5.35335 9.9001C5.40502 9.9526 5.43493 10.0226 5.43493 10.0967V10.4701C5.43493 11.4909 6.06911 12.3626 6.96244 12.7218L5.64917 17.3284C5.58417 17.5575 5.65498 17.8043 5.83248 17.9643C6.00914 18.1234 6.26082 18.1693 6.48332 18.0801L8.79004 17.156C9.84004 16.7376 10.9949 16.7376 12.0432 17.156L14.3516 18.0809C14.4274 18.1109 14.5066 18.1259 14.5841 18.1259C14.7366 18.1259 14.8857 18.0709 15.0024 17.9651C15.1799 17.8051 15.2507 17.5593 15.1857 17.3293L13.8724 12.7226C14.7658 12.3634 15.3999 11.4917 15.3999 10.4709V10.0975C15.3999 10.0234 15.429 9.95339 15.4815 9.90173L15.7474 9.63592C15.7474 9.63592 15.7474 9.63594 15.7474 9.6351C16.6933 8.6876 16.6933 7.14592 15.7466 6.19842ZM12.5067 15.9943C11.1608 15.4576 9.67662 15.4568 8.32495 15.9943L7.19987 16.4451L8.21081 12.8993H8.23584C8.30917 12.8993 8.3807 12.9293 8.43237 12.9801L8.69747 13.2459C9.1708 13.7193 9.79248 13.9568 10.4158 13.9568C11.0375 13.9568 11.66 13.7201 12.1342 13.2459L12.399 12.9809C12.4507 12.9293 12.5224 12.8993 12.5958 12.8993H12.6208L13.6315 16.4451L12.5067 15.9943ZM14.8632 8.75091L14.5975 9.01672C14.3084 9.30505 14.1499 9.68923 14.1499 10.0967V10.4701C14.1499 11.1201 13.6207 11.6493 12.9707 11.6493H12.5974C12.1949 11.6493 11.8008 11.8126 11.5167 12.0976L11.2516 12.3626C10.8058 12.8076 10.0291 12.8076 9.58329 12.3626L9.31819 12.0968C9.03403 11.8126 8.6408 11.6493 8.23747 11.6493H7.86413C7.21413 11.6493 6.68493 11.1201 6.68493 10.4701V10.0967C6.68493 9.6884 6.52671 9.30507 6.23755 9.0159L5.97164 8.75091C5.51247 8.29091 5.51247 7.54178 5.97164 7.08261L6.23755 6.81681C6.52671 6.52847 6.68493 6.14429 6.68493 5.73679V5.36346C6.68493 4.71346 7.21413 4.18426 7.86413 4.18426H8.23747C8.63997 4.18426 9.03403 4.02095 9.31819 3.73595L9.58329 3.47096C10.0291 3.02596 10.8058 3.02596 11.2516 3.47096L11.5167 3.73677C11.8008 4.02094 12.1941 4.18426 12.5974 4.18426H12.9707C13.6207 4.18426 14.1499 4.71346 14.1499 5.36346V5.73679C14.1499 6.14512 14.3084 6.52845 14.5975 6.81762L14.8632 7.08261C15.3224 7.54261 15.3224 8.29091 14.8632 8.75091ZM12.7675 6.52262L11.7024 6.3684L11.2432 5.44341C11.0866 5.12675 10.77 4.93092 10.4166 4.93092C10.0625 4.93092 9.74584 5.12758 9.59 5.44341L9.13082 6.3684L8.06575 6.52262C7.72325 6.57262 7.44325 6.80757 7.33659 7.13673C7.22909 7.46673 7.31754 7.82097 7.56588 8.06264L8.33492 8.8093L8.15995 9.82096C8.09995 10.1693 8.23994 10.5151 8.52494 10.7235C8.80994 10.9318 9.18244 10.9601 9.49744 10.7951L10.4166 10.3142L11.3366 10.7959C11.4725 10.8667 11.619 10.9018 11.7657 10.9018C11.9565 10.9018 12.1475 10.8409 12.3091 10.7225C12.595 10.5142 12.7341 10.1684 12.6741 9.82177L12.4991 8.80757L13.2692 8.06091C13.5175 7.81924 13.605 7.4651 13.4975 7.1351C13.39 6.8076 13.11 6.57262 12.7675 6.52262ZM11.4976 8.03924C11.2826 8.24674 11.1849 8.54595 11.2357 8.84012L11.3291 9.38089L10.8341 9.1218C10.7041 9.05346 10.5608 9.02007 10.4174 9.02007C10.2733 9.02007 10.1292 9.05428 9.99752 9.12261L9.50415 9.38089L9.59753 8.83931C9.64837 8.54514 9.55004 8.24674 9.33671 8.03924L8.94324 7.65757L9.48828 7.57924C9.78328 7.53674 10.0374 7.35264 10.169 7.08597L10.4158 6.58925L10.6624 7.08597C10.7941 7.35264 11.0492 7.53757 11.3425 7.57924L11.8884 7.65838L11.4976 8.03924Z" fill="#4A4A52"/>
                                </svg>

                            {{ __('Upgrade Plan') }}
                        </a>
                    </li>
                    <li>
                        <a href="#business-view-modal" class="business-view" data-bs-toggle="modal"
                            data-image="{{ asset($business->pictureUrl ?? 'assets/img/default-shop.svg') }}"
                            data-name="{{ $business->companyName }}" data-address="{{ $business->address }}"
                            data-category="{{ $business->category->name ?? '' }}"
                            data-phone="{{ $business->phoneNumber }}"
                            data-package="{{ $business->enrolled_plan->plan->subscriptionName ?? '' }}"
                            data-last_enroll="{{ formatted_date($business->subscriptionDate) }}"
                            data-expired_date="{{ formatted_date($business->will_expire) }}"
                            data-created_date="{{ formatted_date($business->created_at) }}">
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M17.696 8.44836C16.6019 6.61586 14.1459 3.54175 10.0001 3.54175C5.85428 3.54175 3.39836 6.61586 2.30419 8.44836C1.73169 9.40503 1.73169 10.5943 2.30419 11.5518C3.39836 13.3843 5.85428 16.4584 10.0001 16.4584C14.1459 16.4584 16.6019 13.3843 17.696 11.5518C18.2685 10.5943 18.2685 9.40586 17.696 8.44836ZM16.6234 10.9101C15.6651 12.5151 13.5293 15.2084 10.0001 15.2084C6.47095 15.2084 4.33512 12.5159 3.37678 10.9101C3.04178 10.3484 3.04178 9.6509 3.37678 9.08923C4.33512 7.48423 6.47095 4.79093 10.0001 4.79093C13.5293 4.79093 15.6651 7.4834 16.6234 9.08923C16.9593 9.65173 16.9593 10.3484 16.6234 10.9101ZM10.0001 6.45841C8.04678 6.45841 6.45845 8.04758 6.45845 10.0001C6.45845 11.9526 8.04678 13.5417 10.0001 13.5417C11.9534 13.5417 13.5418 11.9526 13.5418 10.0001C13.5418 8.04758 11.9534 6.45841 10.0001 6.45841ZM10.0001 12.2917C8.73595 12.2917 7.70845 11.2642 7.70845 10.0001C7.70845 8.73592 8.73595 7.70842 10.0001 7.70842C11.2643 7.70842 12.2918 8.73592 12.2918 10.0001C12.2918 11.2642 11.2643 12.2917 10.0001 12.2917Z" fill="#4A4A52"/>
                            </svg>

                            {{ __('View') }}
                        </a>
                    </li>
                    <li>
                        <a href="{{ route('admin.business.edit', $business->id) }}" class="">
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M13.6874 3.83757L14.5124 3.01258C15.1959 2.32914 16.304 2.32914 16.9874 3.01258C17.6709 3.69603 17.6709 4.80411 16.9874 5.48756L16.1624 6.31255M13.6874 3.83757L8.138 9.387C7.71508 9.81 7.41505 10.3398 7.27 10.9201L6.66669 13.3333L9.07994 12.73C9.66019 12.585 10.19 12.2849 10.613 11.862L16.1624 6.31255M13.6874 3.83757L16.1624 6.31255" stroke="#4A4A52" stroke-width="1.25" stroke-linejoin="round"/>
                            <path d="M15.8333 11.2501C15.8333 13.9897 15.8332 15.3594 15.0767 16.2814C14.9382 16.4502 14.7834 16.6049 14.6146 16.7434C13.6927 17.5001 12.3228 17.5001 9.58325 17.5001H9.16667C6.02397 17.5001 4.45263 17.5001 3.47632 16.5237C2.50002 15.5475 2.5 13.9761 2.5 10.8334V10.4167C2.5 7.67718 2.5 6.30741 3.25662 5.38545C3.39514 5.21666 3.54992 5.06189 3.7187 4.92336C4.64066 4.16675 6.01043 4.16675 8.75 4.16675" stroke="#4A4A52" stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>

                            {{ __('Edit') }}
                        </a>
                    </li>
                    <li>
                        <a href="{{ route('admin.business.destroy', $business->id) }}" class="confirm-action"
                            data-method="DELETE">
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M17.5 4.375H14.5342C13.7833 4.375 13.7517 4.28 13.5458 3.66333L13.3775 3.1575C13.1217 2.39083 12.4075 1.875 11.5992 1.875H8.40083C7.59249 1.875 6.8775 2.39 6.6225 3.1575L6.45417 3.66333C6.24834 4.28083 6.21666 4.375 5.46583 4.375H2.5C2.155 4.375 1.875 4.655 1.875 5C1.875 5.345 2.155 5.625 2.5 5.625H3.58166L4.22084 15.2075C4.34417 17.0617 5.48084 18.125 7.33917 18.125H12.6617C14.5192 18.125 15.6558 17.0617 15.78 15.2075L16.4192 5.625H17.5C17.845 5.625 18.125 5.345 18.125 5C18.125 4.655 17.845 4.375 17.5 4.375ZM7.80833 3.5525C7.89416 3.29667 8.13166 3.125 8.40083 3.125H11.5992C11.8683 3.125 12.1067 3.29667 12.1917 3.5525L12.36 4.05833C12.3967 4.1675 12.4333 4.27333 12.4733 4.375H7.525C7.565 4.2725 7.60251 4.16666 7.63917 4.05833L7.80833 3.5525ZM14.5317 15.1242C14.4525 16.3183 13.8575 16.875 12.6608 16.875H7.33833C6.14167 16.875 5.5475 16.3192 5.4675 15.1242L4.83417 5.625H5.465C5.56917 5.625 5.65583 5.61417 5.74917 5.6075C5.7775 5.61167 5.80333 5.625 5.8325 5.625H14.1658C14.1958 5.625 14.2208 5.61167 14.2492 5.6075C14.3425 5.61417 14.4292 5.625 14.5333 5.625H15.1642L14.5317 15.1242ZM12.2917 9.16667V13.3333C12.2917 13.6783 12.0117 13.9583 11.6667 13.9583C11.3217 13.9583 11.0417 13.6783 11.0417 13.3333V9.16667C11.0417 8.82167 11.3217 8.54167 11.6667 8.54167C12.0117 8.54167 12.2917 8.82167 12.2917 9.16667ZM8.95833 9.16667V13.3333C8.95833 13.6783 8.67833 13.9583 8.33333 13.9583C7.98833 13.9583 7.70833 13.6783 7.70833 13.3333V9.16667C7.70833 8.82167 7.98833 8.54167 8.33333 8.54167C8.67833 8.54167 8.95833 8.82167 8.95833 9.16667Z" fill="#4A4A52"/>
                                </svg>

                            {{ __('Delete') }}
                        </a>
                    </li>
                </ul>
            </div>
        </td>
    </tr>
@endforeach
