@extends('layouts.master')

@section('title')
    {{ __('Add Store') }}
@endsection

@section('main_content')
<div class="erp-table-section">
    <div class="container-fluid">
        <div class="card border-0">
            <div class="card-bodys ">
                <div class="table-header p-16">
                    <h4>{{__('Add New Store')}}</h4>
                    @can('business-read')
                        <a href="{{ route('admin.business.index') }}" class="add-order-btn rounded-2"><i class="far fa-list" aria-hidden="true"></i> {{ __('Store List') }}</a>
                    @endcan
                </div>
                <div class="order-form-section p-16">
                    <form action="{{ route('admin.business.store') }}" method="POST" class="ajaxform_instant_reload">
                        @csrf
                        <div class="add-suplier-modal-wrapper d-block">
                            <div class="row">

                                <div class="col-lg-6 mb-2">
                                    <label>{{ __('Business Name') }}</label>
                                    <input type="text" name="companyName" required class="form-control" placeholder="{{ __('Enter Business Name') }}">
                                </div>

                                <div class="col-lg-6 mb-2">
                                    <label>{{__('Business Category')}}</label>
                                    <div class="gpt-up-down-arrow position-relative">
                                        <select name="business_category_id" required  class="form-control choices-select table-select w-100 role">
                                            <option value=""> {{__('Select Category')}}</option>
                                            @foreach ($categories as $category)
                                                <option value="{{ $category->id }}"> {{ ucfirst($category->name) }} </option>
                                            @endforeach
                                        </select>
                                        <span></span>
                                    </div>
                                </div>

                                <div class="col-lg-6 mb-2">
                                    <label>{{__('Subscription Plan')}}</label>
                                    <div class="gpt-up-down-arrow position-relative">
                                        <select name="plan_subscribe_id"
                                                class="form-control table-select choices-select w-100 role">
                                            <option value=""> {{__('Select One')}}</option>
                                            @foreach ($plans as $plan)
                                                <option value="{{ $plan->id }}"> {{ ucfirst($plan->subscriptionName) }} </option>
                                            @endforeach
                                        </select>
                                        <span></span>
                                    </div>
                                </div>

                                <div class="col-lg-6 mb-2">
                                    <label>{{ __('Phone') }}</label>
                                    <input type="text" name="phoneNumber" required class="form-control" placeholder="{{ __('Enter Phone Number') }}">
                                </div>

                                <div class="col-lg-6 mb-2">
                                    <label>{{ __('Email') }}</label>
                                    <input type="email" name="email" required class="form-control" placeholder="{{ __('Enter Email') }}">
                                </div>

                                <div class="col-lg-6 mb-2">
                                    <label>{{ __('Shop Opening Balance') }}</label>
                                    <input type="number" name="shopOpeningBalance" required class="form-control" placeholder="{{ __('Enter Balance') }}">
                                </div>

                                <div class="col-lg-6 mb-2">
                                    <label>{{ __('Address') }}</label>
                                    <input type="text" name="address" required class="form-control" placeholder="{{ __('Enter Address') }}">
                                </div>

                                <div class="col-lg-6">
                                    <label>{{__('Password')}}</label>
                                    <div class="pass-field">
                                        <input type="password" name="password" required class="form-control" placeholder="{{ __('Enter Password') }}">
                                        <i class="far fa-eye eye-btn"></i>
                                    </div>
                                </div>

                                <div class="col-lg-6 ">
                                    <label class="img-label">{{ __('Image') }}</label>
                                    <div class=" chosen-img d-flex align-items-center gap-2 ">
                                        <div class="w-100">
                                            <input type="file" accept="image/*" name="pictureUrl" class="form-control w-100 file-input-change" data-id="image">
                                        </div>
                                        <div class="img-wrp">
                                            <img src="{{ asset('assets/img/icon/upload.png') }}" alt="user"
                                            id="image" class="table-img">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-12">
                                    <div class="button-group text-center mt-3">
                                        <button type="reset" class="theme-btn border-btn m-2">{{ __('Reset') }}</button>
                                        <button class="theme-btn m-2 submit-btn">{{ __('Save') }}</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
