/** confirm modal start */
$.ajaxSetup({
    headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
});

// Function to create and append modal if not exists
function createDeleteModal() {
    if ($('#single-delete-modal').length === 0) {
        const modalHtml = `
        <div class="modal fade" id="single-delete-modal" tabindex="-1" aria-labelledby="delete-confirmation-modal-label" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="text-end">
                        <button type="button" class="btn-close m-3 mb-0" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="delete-modal text-center mb-lg-4">
                        <svg class="delete-svg" width="64" height="64" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M52.1522 13.518L52.4733 15.145C52.6745 16.1647 52.011 17.1545 50.9913 17.3557L14.06 24.6441C13.0403 24.8453 12.0505 24.1818 11.8493 23.1621L11.5282 21.5351C11.3269 20.5153 11.9904 19.5256 13.0102 19.3243L49.9414 12.036C50.961 11.8347 51.9509 12.4982 52.1522 13.518Z" fill="white"/>
                            <path d="M47.9786 59.2291L51.188 27.0661H14.5749L17.7843 59.2291C17.9771 61.1619 19.6033 62.6338 21.5456 62.6338H44.2174C46.1596 62.6339 47.7858 61.1619 47.9786 59.2291ZM47.6538 9.88488L48.148 12.3893L14.803 18.9699L14.3088 16.4655C14.0019 14.9106 15.0136 13.4014 16.5685 13.0945L44.2829 7.62513C45.8376 7.31838 47.3469 8.33 47.6538 9.88488Z" fill="#FF3B30" fill-opacity="0.2"/>
                            <path d="M39.5828 8.55464L34.9481 9.46926L34.412 6.75264C34.3694 6.53833 34.2436 6.34966 34.0621 6.22801C33.8807 6.10636 33.6583 6.06167 33.444 6.10376L26.0153 7.56976C25.801 7.61229 25.6123 7.73809 25.4907 7.91956C25.369 8.10103 25.3243 8.32336 25.3663 8.53776L25.9025 11.2544L21.2677 12.169L20.7316 9.45239C20.1392 6.45101 22.0992 3.52726 25.1007 2.93489L32.5293 1.46889C35.5307 0.87651 38.4545 2.83651 39.0468 5.83789L39.5828 8.55464Z" fill="white"/>
                            <path d="M11.2473 23.2816C11.5152 24.637 12.8273 25.513 14.1781 25.2463L51.109 17.958C52.4582 17.6917 53.3397 16.3771 53.074 15.0275L52.7532 13.4005V13.4002C52.4863 12.0512 51.1736 11.1698 49.8225 11.4361L48.6305 11.6713L48.2548 9.76783C47.8817 7.87733 46.0488 6.65333 44.1645 7.02583L40.0656 7.83471L39.6481 5.71933C38.9898 2.38508 35.7471 0.208207 32.4108 0.867832L24.9822 2.33383C21.6493 2.99146 19.4731 6.23821 20.1307 9.57108L20.5482 11.6866L16.4502 12.4953C14.5628 12.8676 13.3345 14.6965 13.7073 16.5861L14.083 18.4895L12.8912 18.7247C11.5402 18.9911 10.6591 20.3017 10.9268 21.6548L11.2473 23.2816ZM25.2191 3.53596L32.6477 2.06996C35.3288 1.54221 37.9206 3.29283 38.4452 5.95658L38.8628 8.07183L35.4307 8.74921L35.0137 6.63396C34.86 5.85633 34.1 5.34896 33.3257 5.50246L25.8971 6.96846C25.1198 7.12158 24.6118 7.87883 24.765 8.65646L25.1826 10.7717L21.7503 11.4491L21.3333 9.33358C20.8061 6.66396 22.5492 4.06283 25.2191 3.53596ZM25.9676 8.41921C25.9568 8.36419 25.9683 8.30714 25.9994 8.26054C26.0306 8.21395 26.079 8.1816 26.134 8.17058L33.5626 6.70458C33.6176 6.69392 33.6746 6.70545 33.7211 6.73667C33.7677 6.76789 33.8 6.81626 33.811 6.87121L34.2285 8.98671L26.3852 10.5346L25.9676 8.41921ZM16.687 13.6973L44.4013 8.22796C45.6215 7.98746 46.81 8.77796 47.0521 10.0053L47.4278 11.9085L15.285 18.2517L14.9098 16.3483C14.6676 15.1275 15.4611 13.94 16.687 13.6973ZM13.128 19.9266L50.0595 12.6382C50.757 12.5017 51.417 12.96 51.5506 13.6378L51.8713 15.2645C52.0072 15.9513 51.5583 16.6203 50.8721 16.7558L13.9411 24.0442C13.2556 24.1803 12.5852 23.7337 12.45 23.0446L12.1292 21.4173C12.0968 21.2539 12.0969 21.0856 12.1296 20.9222C12.1622 20.7588 12.2268 20.6034 12.3196 20.4649C12.4123 20.3265 12.5315 20.2077 12.6702 20.1153C12.8089 20.0229 12.9645 19.9588 13.128 19.9266ZM48.5881 59.2917L51.7977 27.1286C51.8062 27.0434 51.7967 26.9575 51.7699 26.8762C51.7431 26.7949 51.6996 26.7202 51.6421 26.6568C51.5847 26.5934 51.5146 26.5426 51.4364 26.5079C51.3582 26.4732 51.2735 26.4552 51.188 26.4552H14.5747C14.4891 26.4552 14.4045 26.4732 14.3263 26.5079C14.2481 26.5426 14.178 26.5934 14.1206 26.6568C14.0631 26.7202 14.0196 26.795 13.9928 26.8762C13.966 26.9575 13.9565 27.0434 13.965 27.1286L17.174 59.2921C17.2794 60.3774 17.7859 61.3843 18.5944 62.116C19.4028 62.8477 20.4552 63.2515 21.5456 63.2485H44.217C45.3074 63.2516 46.3598 62.8478 47.1683 62.116C47.9767 61.3842 48.483 60.3771 48.5881 59.2917ZM18.3935 59.1702L15.2515 27.6805H50.5112L47.3686 59.1702C47.2929 59.9528 46.9278 60.6789 46.3449 61.2066C45.762 61.7342 45.0032 62.0253 44.217 62.023H21.5457C20.7595 62.0251 20.0007 61.7339 19.4178 61.2063C18.8348 60.6788 18.4696 59.9528 18.3935 59.1702Z" fill="#FF3B30"/>
                            <path d="M22.8549 34.2773C22.7745 34.2773 22.6948 34.2932 22.6204 34.324C22.5461 34.3547 22.4785 34.3999 22.4216 34.4568C22.3647 34.5137 22.3196 34.5812 22.2888 34.6556C22.258 34.7299 22.2422 34.8096 22.2422 34.8901V54.8107C22.2422 55.1491 22.5162 55.4235 22.8549 55.4235C23.1937 55.4235 23.4677 55.1491 23.4677 54.8107V34.8901C23.4677 34.8096 23.4519 34.7299 23.4211 34.6556C23.3903 34.5812 23.3452 34.5137 23.2883 34.4568C23.2314 34.3999 23.1638 34.3547 23.0894 34.324C23.0151 34.2932 22.9354 34.2773 22.8549 34.2773ZM29.5398 34.2773C29.4593 34.2773 29.3797 34.2932 29.3053 34.324C29.231 34.3547 29.1634 34.3999 29.1065 34.4568C29.0496 34.5137 29.0045 34.5812 28.9737 34.6556C28.9429 34.7299 28.927 34.8096 28.9271 34.8901V54.8107C28.927 54.8912 28.9429 54.9709 28.9736 55.0452C29.0044 55.1196 29.0496 55.1872 29.1065 55.2441C29.1634 55.301 29.2309 55.3461 29.3053 55.3769C29.3796 55.4077 29.4593 55.4235 29.5398 55.4235C29.6203 55.4235 29.7 55.4076 29.7743 55.3769C29.8487 55.3461 29.9162 55.3009 29.9731 55.244C30.03 55.1871 30.0752 55.1196 30.106 55.0452C30.1367 54.9709 30.1526 54.8912 30.1526 54.8107V34.8901C30.1526 34.8096 30.1367 34.7299 30.106 34.6556C30.0752 34.5812 30.03 34.5137 29.9731 34.4568C29.9162 34.3999 29.8487 34.3547 29.7743 34.324C29.7 34.2932 29.6203 34.2773 29.5398 34.2773ZM36.2242 34.2773C36.1437 34.2773 36.064 34.2932 35.9897 34.324C35.9153 34.3547 35.8478 34.3999 35.7909 34.4568C35.734 34.5137 35.6888 34.5812 35.658 34.6556C35.6273 34.7299 35.6114 34.8096 35.6114 34.8901V54.8107C35.6114 55.1491 35.8854 55.4235 36.2242 55.4235C36.5629 55.4235 36.8369 55.1491 36.8369 54.8107V34.8901C36.8369 34.7276 36.7724 34.5717 36.6575 34.4568C36.5426 34.3419 36.3867 34.2773 36.2242 34.2773ZM42.9091 34.2773C42.8286 34.2773 42.7489 34.2932 42.6746 34.324C42.6002 34.3547 42.5326 34.3999 42.4757 34.4568C42.4188 34.5137 42.3737 34.5812 42.3429 34.6556C42.3121 34.7299 42.2963 34.8096 42.2963 34.8901V54.8107C42.2963 55.1491 42.5703 55.4235 42.9091 55.4235C43.2478 55.4235 43.5218 55.1491 43.5218 54.8107V34.8901C43.5218 34.8096 43.506 34.7299 43.4752 34.6556C43.4444 34.5812 43.3993 34.5137 43.3424 34.4568C43.2855 34.3999 43.2179 34.3547 43.1436 34.324C43.0692 34.2932 42.9895 34.2773 42.9091 34.2773Z" fill="#FF3B30"/>
                            </svg>

                            <h5>Are You Sure?</h5>
                            <p>You won't be able to revert this!</p>
                        </div>
                        <div class="d-flex justify-content-center">
                            <div class="button-group delete-btn-grup">
                                <button class="btn reset-btn border rounded" data-bs-dismiss="modal">Cancel</button>
                                <button class="btn theme-btn border rounded single-delete-confirmation-button">Yes</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>`;
        $('body').append(modalHtml);
    }
}

let actionUrl = '';
let actionMethod = 'POST';

// Click on any delete/confirm-action button
$(document).on('click', '.confirm-action', function (event) {
    event.preventDefault();

    actionUrl = $(this).data('action') ?? $(this).attr('href');
    actionMethod = $(this).data('method') ?? 'POST';

    createDeleteModal();

    // Show the modal
    $('#single-delete-modal').modal('show');
});

// Handle delete confirmation click
$(document).on('click', '.single-delete-confirmation-button', function () {
    const $btn = $(this);
    $btn.prop('disabled', true).text('Deleting...');

    $.ajax({
        type: actionMethod,
        url: actionUrl,
        success: function (response) {
            $('#single-delete-modal').modal('hide');
            $btn.prop('disabled', false).text('Yes, Delete It!');

            if (response.redirect) {
                window.sessionStorage.hasPreviousMessage = true;
                window.sessionStorage.previousMessage = response.message ?? null;
                location.href = response.redirect;
            } else {
                Notify('success', response);
            }
        },
        error: function (xhr) {
            $('#single-delete-modal').modal('hide');
            $btn.prop('disabled', false).text('Yes, Delete It!');
            Notify('error', xhr);
        }
    });
});


/** filter all from start */
$(".searchInput").on("input submit", function (e) {
    e.preventDefault();
    const searchText = $(".searchInput").val();
    const url = $(this).attr("action");
    $.ajax({
        url: url,
        type: "GET",
        data: {search: searchText},
        success: function (response) {
            $(".searchResults").html(response.data);
        }
    });
});

/** filter all from  end */

/** DELETE ACTION */
$(document).on("click", ".delete-confirm", function (e) {
    e.preventDefault();
    let t = $(this),
        o = t.attr("href") ?? t.data("action"),
        i = t.html();

        // Create modal dynamically
    let confirmationModal = `
        <div class="modal fade" id="delete-confirmation-modal" tabindex="-1" aria-labelledby="delete-confirmation-modal-label" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="text-end">
                        <button type="button" class="btn-close m-3 mb-0" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="delete-modal text-center mb-lg-4">
                            <svg class="delete-svg" width="64" height="64" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M52.1522 13.518L52.4733 15.145C52.6745 16.1647 52.011 17.1545 50.9913 17.3557L14.06 24.6441C13.0403 24.8453 12.0505 24.1818 11.8493 23.1621L11.5282 21.5351C11.3269 20.5153 11.9904 19.5256 13.0102 19.3243L49.9414 12.036C50.961 11.8347 51.9509 12.4982 52.1522 13.518Z" fill="white"/>
                            <path d="M47.9786 59.2291L51.188 27.0661H14.5749L17.7843 59.2291C17.9771 61.1619 19.6033 62.6338 21.5456 62.6338H44.2174C46.1596 62.6339 47.7858 61.1619 47.9786 59.2291ZM47.6538 9.88488L48.148 12.3893L14.803 18.9699L14.3088 16.4655C14.0019 14.9106 15.0136 13.4014 16.5685 13.0945L44.2829 7.62513C45.8376 7.31838 47.3469 8.33 47.6538 9.88488Z" fill="#FF3B30" fill-opacity="0.2"/>
                            <path d="M39.5828 8.55464L34.9481 9.46926L34.412 6.75264C34.3694 6.53833 34.2436 6.34966 34.0621 6.22801C33.8807 6.10636 33.6583 6.06167 33.444 6.10376L26.0153 7.56976C25.801 7.61229 25.6123 7.73809 25.4907 7.91956C25.369 8.10103 25.3243 8.32336 25.3663 8.53776L25.9025 11.2544L21.2677 12.169L20.7316 9.45239C20.1392 6.45101 22.0992 3.52726 25.1007 2.93489L32.5293 1.46889C35.5307 0.87651 38.4545 2.83651 39.0468 5.83789L39.5828 8.55464Z" fill="white"/>
                            <path d="M11.2473 23.2816C11.5152 24.637 12.8273 25.513 14.1781 25.2463L51.109 17.958C52.4582 17.6917 53.3397 16.3771 53.074 15.0275L52.7532 13.4005V13.4002C52.4863 12.0512 51.1736 11.1698 49.8225 11.4361L48.6305 11.6713L48.2548 9.76783C47.8817 7.87733 46.0488 6.65333 44.1645 7.02583L40.0656 7.83471L39.6481 5.71933C38.9898 2.38508 35.7471 0.208207 32.4108 0.867832L24.9822 2.33383C21.6493 2.99146 19.4731 6.23821 20.1307 9.57108L20.5482 11.6866L16.4502 12.4953C14.5628 12.8676 13.3345 14.6965 13.7073 16.5861L14.083 18.4895L12.8912 18.7247C11.5402 18.9911 10.6591 20.3017 10.9268 21.6548L11.2473 23.2816ZM25.2191 3.53596L32.6477 2.06996C35.3288 1.54221 37.9206 3.29283 38.4452 5.95658L38.8628 8.07183L35.4307 8.74921L35.0137 6.63396C34.86 5.85633 34.1 5.34896 33.3257 5.50246L25.8971 6.96846C25.1198 7.12158 24.6118 7.87883 24.765 8.65646L25.1826 10.7717L21.7503 11.4491L21.3333 9.33358C20.8061 6.66396 22.5492 4.06283 25.2191 3.53596ZM25.9676 8.41921C25.9568 8.36419 25.9683 8.30714 25.9994 8.26054C26.0306 8.21395 26.079 8.1816 26.134 8.17058L33.5626 6.70458C33.6176 6.69392 33.6746 6.70545 33.7211 6.73667C33.7677 6.76789 33.8 6.81626 33.811 6.87121L34.2285 8.98671L26.3852 10.5346L25.9676 8.41921ZM16.687 13.6973L44.4013 8.22796C45.6215 7.98746 46.81 8.77796 47.0521 10.0053L47.4278 11.9085L15.285 18.2517L14.9098 16.3483C14.6676 15.1275 15.4611 13.94 16.687 13.6973ZM13.128 19.9266L50.0595 12.6382C50.757 12.5017 51.417 12.96 51.5506 13.6378L51.8713 15.2645C52.0072 15.9513 51.5583 16.6203 50.8721 16.7558L13.9411 24.0442C13.2556 24.1803 12.5852 23.7337 12.45 23.0446L12.1292 21.4173C12.0968 21.2539 12.0969 21.0856 12.1296 20.9222C12.1622 20.7588 12.2268 20.6034 12.3196 20.4649C12.4123 20.3265 12.5315 20.2077 12.6702 20.1153C12.8089 20.0229 12.9645 19.9588 13.128 19.9266ZM48.5881 59.2917L51.7977 27.1286C51.8062 27.0434 51.7967 26.9575 51.7699 26.8762C51.7431 26.7949 51.6996 26.7202 51.6421 26.6568C51.5847 26.5934 51.5146 26.5426 51.4364 26.5079C51.3582 26.4732 51.2735 26.4552 51.188 26.4552H14.5747C14.4891 26.4552 14.4045 26.4732 14.3263 26.5079C14.2481 26.5426 14.178 26.5934 14.1206 26.6568C14.0631 26.7202 14.0196 26.795 13.9928 26.8762C13.966 26.9575 13.9565 27.0434 13.965 27.1286L17.174 59.2921C17.2794 60.3774 17.7859 61.3843 18.5944 62.116C19.4028 62.8477 20.4552 63.2515 21.5456 63.2485H44.217C45.3074 63.2516 46.3598 62.8478 47.1683 62.116C47.9767 61.3842 48.483 60.3771 48.5881 59.2917ZM18.3935 59.1702L15.2515 27.6805H50.5112L47.3686 59.1702C47.2929 59.9528 46.9278 60.6789 46.3449 61.2066C45.762 61.7342 45.0032 62.0253 44.217 62.023H21.5457C20.7595 62.0251 20.0007 61.7339 19.4178 61.2063C18.8348 60.6788 18.4696 59.9528 18.3935 59.1702Z" fill="#FF3B30"/>
                            <path d="M22.8549 34.2773C22.7745 34.2773 22.6948 34.2932 22.6204 34.324C22.5461 34.3547 22.4785 34.3999 22.4216 34.4568C22.3647 34.5137 22.3196 34.5812 22.2888 34.6556C22.258 34.7299 22.2422 34.8096 22.2422 34.8901V54.8107C22.2422 55.1491 22.5162 55.4235 22.8549 55.4235C23.1937 55.4235 23.4677 55.1491 23.4677 54.8107V34.8901C23.4677 34.8096 23.4519 34.7299 23.4211 34.6556C23.3903 34.5812 23.3452 34.5137 23.2883 34.4568C23.2314 34.3999 23.1638 34.3547 23.0894 34.324C23.0151 34.2932 22.9354 34.2773 22.8549 34.2773ZM29.5398 34.2773C29.4593 34.2773 29.3797 34.2932 29.3053 34.324C29.231 34.3547 29.1634 34.3999 29.1065 34.4568C29.0496 34.5137 29.0045 34.5812 28.9737 34.6556C28.9429 34.7299 28.927 34.8096 28.9271 34.8901V54.8107C28.927 54.8912 28.9429 54.9709 28.9736 55.0452C29.0044 55.1196 29.0496 55.1872 29.1065 55.2441C29.1634 55.301 29.2309 55.3461 29.3053 55.3769C29.3796 55.4077 29.4593 55.4235 29.5398 55.4235C29.6203 55.4235 29.7 55.4076 29.7743 55.3769C29.8487 55.3461 29.9162 55.3009 29.9731 55.244C30.03 55.1871 30.0752 55.1196 30.106 55.0452C30.1367 54.9709 30.1526 54.8912 30.1526 54.8107V34.8901C30.1526 34.8096 30.1367 34.7299 30.106 34.6556C30.0752 34.5812 30.03 34.5137 29.9731 34.4568C29.9162 34.3999 29.8487 34.3547 29.7743 34.324C29.7 34.2932 29.6203 34.2773 29.5398 34.2773ZM36.2242 34.2773C36.1437 34.2773 36.064 34.2932 35.9897 34.324C35.9153 34.3547 35.8478 34.3999 35.7909 34.4568C35.734 34.5137 35.6888 34.5812 35.658 34.6556C35.6273 34.7299 35.6114 34.8096 35.6114 34.8901V54.8107C35.6114 55.1491 35.8854 55.4235 36.2242 55.4235C36.5629 55.4235 36.8369 55.1491 36.8369 54.8107V34.8901C36.8369 34.7276 36.7724 34.5717 36.6575 34.4568C36.5426 34.3419 36.3867 34.2773 36.2242 34.2773ZM42.9091 34.2773C42.8286 34.2773 42.7489 34.2932 42.6746 34.324C42.6002 34.3547 42.5326 34.3999 42.4757 34.4568C42.4188 34.5137 42.3737 34.5812 42.3429 34.6556C42.3121 34.7299 42.2963 34.8096 42.2963 34.8901V54.8107C42.2963 55.1491 42.5703 55.4235 42.9091 55.4235C43.2478 55.4235 43.5218 55.1491 43.5218 54.8107V34.8901C43.5218 34.8096 43.506 34.7299 43.4752 34.6556C43.4444 34.5812 43.3993 34.5137 43.3424 34.4568C43.2855 34.3999 43.2179 34.3547 43.1436 34.324C43.0692 34.2932 42.9895 34.2773 42.9091 34.2773Z" fill="#FF3B30"/>
                            </svg>

                            <h5>Are You Sure?</h5>
                            <p>You won't be able to revert this!</p>
                        </div>
                         <div class="d-flex justify-content-center">
                            <div class="button-group">
                                <button class="btn reset-btn border rounded" data-bs-dismiss="modal">Cancel</button>
                                <button class="btn theme-btn border rounded delete-confirmation-button">Yes</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    `;

    $('body').append(confirmationModal); // Append modal to the body
    $('#delete-confirmation-modal').modal('show');

    // handle dynamic modal
    $('.delete-confirmation-button').on('click', function () {
        $.ajax({
            url: o,
            data: { _token: CSRF_TOKEN },
            type: "DELETE",
            beforeSend: function () {
                t.html($savingLoader).attr('disabled', true);
            },
            success: function (e) {
                t.html(i).removeClass("disabled").attr("disabled", false);
                ajaxSuccess(e, t);

            },
            error: function (e) {
                t.html(i).removeClass("disabled").attr("disabled", false);
                Notify(e);
            },
        });

        // Hide and remove modal
        $('#delete-confirmation-modal').modal('hide');
        $('#delete-confirmation-modal').remove();
    });
});

// Listen for input changes and update feature values accordingly
$('#words_limit').on('input', function () {
    $('#word_feature').val($('#words_limit').val() + ' Word Limit');
});

$('#images_limit').on('input', function () {
    $('#image_feature').val($('#images_limit').val() + ' images Limit');
});

//dynamic Field
$(document).on('click', ".service-btn-possition", function () {
    var $duplicateRow = $(this).closest(".duplicate-feature");
    var $lastDuplicateRow = $duplicateRow.clone();

    $lastDuplicateRow.find(".clear-value").val("");

    $lastDuplicateRow.find(".remove-btn-features").removeAttr('disabled');
    $lastDuplicateRow.insertAfter($duplicateRow);
});
$(document).on('click', ".remove-btn-features", function () {
    var $row = $(this).closest(".duplicate-feature");
    $row.remove();
});

// filter form used outside index function
$('.filter-form').on('input change submit', function (e) {
    e.preventDefault();

    var table = $(this).closest('.filter-form').attr('table');
    $.ajax({
        type: "POST",
        url: $(this).closest('.filter-form').attr('action'),
        data: new FormData($(this).closest('.filter-form')[0]), // Use the form
        dataType: "json",
        contentType: false,
        cache: false,
        processData: false,
        success: function (res) {
            $(table).html(res.data);
        }
    });
});

$(".payment-method-nav .payment-items").on("click", function() {
    $("input[name='gateway_id']").prop('checked', false);
    $(this).find("input[name='gateway_id']").prop('checked', true);
});

$(document).ready(function () {
    $('.logoutButton').on('click', function() {
        document.getElementById('logoutForm').submit();
    });
})
