<?php

namespace Database\Seeders;

use App\Models\Product;
use App\Models\ProductVariation;
use Illuminate\Database\Seeder;

class ProductSeeder extends Seeder
{
    public function run(): void
    {
        $products = array(
            array('productName' => 'Spicy Noodles', 'business_id' => '1', 'user_id' => '4', 'category_id' => '6', 'menu_id' => '2', 'status' => '1', 'preparation_time' => '15', 'food_type' => 'veg', 'price_type' => 'variation', 'sales_price' => '0.00', 'images' => '["uploads\\/25\\/09\\/1757487251_68c12093abcd4.png"]', 'description' => 'Very testy maxican noodles', 'meta' => NULL, 'created_at' => '2025-07-16 13:12:15', 'updated_at' => '2026-02-03 05:50:28'),
            array('productName' => 'Spicy Rice', 'business_id' => '1', 'user_id' => NULL, 'category_id' => '5', 'menu_id' => '4', 'status' => '1', 'preparation_time' => '22', 'food_type' => 'non_veg', 'price_type' => 'variation', 'sales_price' => '0.00', 'images' => '["uploads\\/25\\/09\\/1757487055_68c11fcf6d1ee.png"]', 'description' => 'Test Product', 'meta' => NULL, 'created_at' => '2025-07-16 13:12:22', 'updated_at' => '2025-09-10 13:44:18'),
            array('productName' => 'Chicken Burger', 'business_id' => '1', 'user_id' => NULL, 'category_id' => '3', 'menu_id' => '2', 'status' => '1', 'preparation_time' => '10', 'food_type' => 'non_veg', 'price_type' => 'variation', 'sales_price' => '0.00', 'images' => '["uploads\\/25\\/09\\/1757486860_68c11f0c2ca0b.png"]', 'description' => 'Smokey chicken cheese burger', 'meta' => NULL, 'created_at' => '2025-09-10 12:47:40', 'updated_at' => '2025-09-10 13:44:09'),
            array('productName' => 'Dum Biryani', 'business_id' => '1', 'user_id' => NULL, 'category_id' => '5', 'menu_id' => '4', 'status' => '1', 'preparation_time' => '30', 'food_type' => 'non_veg', 'price_type' => 'single', 'sales_price' => '370.00', 'images' => '["uploads\\/25\\/09\\/1757487366_68c121064e620.png"]', 'description' => 'Our spacial checken dum biriyani', 'meta' => NULL, 'created_at' => '2025-09-10 12:56:06', 'updated_at' => '2025-09-10 13:44:01'),
            array('productName' => 'Lemon Juice', 'business_id' => '1', 'user_id' => NULL, 'category_id' => '1', 'menu_id' => '6', 'status' => '1', 'preparation_time' => '5', 'food_type' => 'drink', 'price_type' => 'variation', 'sales_price' => '0.00', 'images' => '["uploads\\/25\\/09\\/1757487498_68c1218a92812.png"]', 'description' => 'Best drink in summer', 'meta' => NULL, 'created_at' => '2025-09-10 12:58:18', 'updated_at' => '2025-09-10 15:22:21'),
            array('productName' => 'Special Tea', 'business_id' => '1', 'user_id' => NULL, 'category_id' => '8', 'menu_id' => '6', 'status' => '1', 'preparation_time' => '18', 'food_type' => 'drink', 'price_type' => 'single', 'sales_price' => '125.00', 'images' => '["uploads\\/25\\/09\\/1757489143_68c127f7cf8d5.png"]', 'description' => 'Very testy tea', 'meta' => NULL, 'created_at' => '2025-09-10 13:17:57', 'updated_at' => '2025-09-10 13:43:18'),
            array('productName' => 'Chicken Pulao', 'business_id' => '1', 'user_id' => NULL, 'category_id' => '7', 'menu_id' => '4', 'status' => '1', 'preparation_time' => NULL, 'food_type' => 'non_veg', 'price_type' => 'single', 'sales_price' => '370.00', 'images' => '["uploads\\/25\\/09\\/1759141755_68da5f7ba4930.png"]', 'description' => NULL, 'meta' => NULL, 'created_at' => '2025-09-29 16:29:15', 'updated_at' => '2025-09-29 16:29:15'),
            array('productName' => 'Shahi Kabab', 'business_id' => '1', 'user_id' => '4', 'category_id' => '7', 'menu_id' => '1', 'status' => '1', 'preparation_time' => NULL, 'food_type' => 'non_veg', 'price_type' => 'single', 'sales_price' => '770.00', 'images' => '["uploads\\/25\\/09\\/1759141914_68da601a32133.png"]', 'description' => NULL, 'meta' => NULL, 'created_at' => '2025-09-29 16:31:54', 'updated_at' => '2026-02-03 05:49:08'),
            array('productName' => 'Veg Pizza', 'business_id' => '1', 'user_id' => NULL, 'category_id' => '2', 'menu_id' => '1', 'status' => '1', 'preparation_time' => NULL, 'food_type' => 'veg', 'price_type' => 'single', 'sales_price' => '475.00', 'images' => '["uploads\\/25\\/09\\/1759141948_68da603c97688.png"]', 'description' => NULL, 'meta' => NULL, 'created_at' => '2025-09-29 16:32:28', 'updated_at' => '2025-09-29 16:32:28'),
            array('productName' => 'Special Pasta', 'business_id' => '1', 'user_id' => '4', 'category_id' => '6', 'menu_id' => '2', 'status' => '1', 'preparation_time' => NULL, 'food_type' => 'others', 'price_type' => 'single', 'sales_price' => '335.00', 'images' => '["uploads\\/25\\/09\\/1759141983_68da605fac147.png"]', 'description' => NULL, 'meta' => NULL, 'created_at' => '2025-09-29 16:33:03', 'updated_at' => '2026-02-03 05:49:44'),
            array('productName' => 'Sunrise Cocktail', 'business_id' => '1', 'user_id' => NULL, 'category_id' => '1', 'menu_id' => '6', 'status' => '1', 'preparation_time' => NULL, 'food_type' => 'drink', 'price_type' => 'single', 'sales_price' => '910.00', 'images' => '["uploads\\/25\\/09\\/1759142351_68da61cf37edf.png"]', 'description' => NULL, 'meta' => NULL, 'created_at' => '2025-09-29 16:39:11', 'updated_at' => '2025-09-29 16:39:11'),
            array('productName' => 'Basmati Rice', 'business_id' => '1', 'user_id' => NULL, 'category_id' => '5', 'menu_id' => '4', 'status' => '1', 'preparation_time' => NULL, 'food_type' => 'others', 'price_type' => 'single', 'sales_price' => '150.00', 'images' => '["uploads\\/25\\/09\\/1759142765_68da636d28cbf.png"]', 'description' => NULL, 'meta' => NULL, 'created_at' => '2025-09-29 16:46:05', 'updated_at' => '2025-09-29 16:46:05'),
            array('productName' => 'Chocolate Cake', 'business_id' => '1', 'user_id' => '4', 'category_id' => '4', 'menu_id' => '5', 'status' => '1', 'preparation_time' => NULL, 'food_type' => 'others', 'price_type' => 'single', 'sales_price' => '250.00', 'images' => '["uploads\\/26\\/02\\/1770034179_6980940337baf.png"]', 'description' => NULL, 'meta' => NULL, 'created_at' => '2026-02-02 12:09:39', 'updated_at' => '2026-02-02 12:09:39'),
            array('productName' => 'Veg Salad', 'business_id' => '1', 'user_id' => '4', 'category_id' => '4', 'menu_id' => '3', 'status' => '1', 'preparation_time' => NULL, 'food_type' => 'veg', 'price_type' => 'single', 'sales_price' => '180.00', 'images' => '["uploads\\/26\\/02\\/1770034463_6980951f5e3b6.png"]', 'description' => NULL, 'meta' => NULL, 'created_at' => '2026-02-02 12:12:36', 'updated_at' => '2026-02-02 12:14:23'),
            array('productName' => 'Special Coffee', 'business_id' => '1', 'user_id' => '4', 'category_id' => '8', 'menu_id' => '6', 'status' => '1', 'preparation_time' => '10', 'food_type' => 'drink', 'price_type' => 'single', 'sales_price' => '219.00', 'images' => '["uploads\\/26\\/02\\/1770110501_6981be25ce8b4.png"]', 'description' => NULL, 'meta' => NULL, 'created_at' => '2026-02-03 09:16:21', 'updated_at' => '2026-02-03 09:21:41'),
            array('productName' => 'Special Combo', 'business_id' => '1', 'user_id' => '4', 'category_id' => '4', 'menu_id' => '2', 'status' => '1', 'preparation_time' => '10', 'food_type' => 'non_veg', 'price_type' => 'single', 'sales_price' => '540.00', 'images' => '["uploads\\/26\\/02\\/1770110790_6981bf466f153.png"]', 'description' => NULL, 'meta' => NULL, 'created_at' => '2026-02-03 09:26:30', 'updated_at' => '2026-02-03 09:26:30'),
            array('productName' => 'Veg Burger', 'business_id' => '1', 'user_id' => '4', 'category_id' => '3', 'menu_id' => '1', 'status' => '1', 'preparation_time' => '15', 'food_type' => 'veg', 'price_type' => 'single', 'sales_price' => '470.00', 'images' => '["uploads\\/26\\/02\\/1770110993_6981c0114eec2.png"]', 'description' => NULL, 'meta' => NULL, 'created_at' => '2026-02-03 09:29:53', 'updated_at' => '2026-02-03 09:29:53'),
            array('productName' => 'Fried Chicken', 'business_id' => '1', 'user_id' => '4', 'category_id' => '7', 'menu_id' => '1', 'status' => '1', 'preparation_time' => '25', 'food_type' => 'non_veg', 'price_type' => 'single', 'sales_price' => '210.00', 'images' => '["uploads\\/26\\/02\\/1770111559_6981c247ccab9.png"]', 'description' => NULL, 'meta' => NULL, 'created_at' => '2026-02-03 09:39:19', 'updated_at' => '2026-02-03 09:39:19'),
            array('productName' => 'Mixed Tomato', 'business_id' => '1', 'user_id' => '4', 'category_id' => '4', 'menu_id' => '3', 'status' => '1', 'preparation_time' => '5', 'food_type' => 'veg', 'price_type' => 'single', 'sales_price' => '75.00', 'images' => '["uploads\\/26\\/02\\/1770111937_6981c3c1843be.png"]', 'description' => NULL, 'meta' => NULL, 'created_at' => '2026-02-03 09:45:37', 'updated_at' => '2026-02-03 09:45:37'),
            array('productName' => 'Cucumber Mix', 'business_id' => '1', 'user_id' => '4', 'category_id' => '4', 'menu_id' => '3', 'status' => '1', 'preparation_time' => '7', 'food_type' => 'veg', 'price_type' => 'single', 'sales_price' => '95.00', 'images' => '["uploads\\/26\\/02\\/1770112632_6981c6783e532.png"]', 'description' => NULL, 'meta' => NULL, 'created_at' => '2026-02-03 09:57:00', 'updated_at' => '2026-02-03 09:57:12'),
            array('productName' => 'Mix Vegetables', 'business_id' => '1', 'user_id' => '4', 'category_id' => '4', 'menu_id' => '3', 'status' => '1', 'preparation_time' => NULL, 'food_type' => 'veg', 'price_type' => 'single', 'sales_price' => '55.00', 'images' => '["uploads\\/26\\/02\\/1770112799_6981c71f86040.png"]', 'description' => NULL, 'meta' => NULL, 'created_at' => '2026-02-03 09:59:59', 'updated_at' => '2026-02-03 09:59:59'),
            array('productName' => 'Combo Cake', 'business_id' => '1', 'user_id' => '4', 'category_id' => '4', 'menu_id' => '5', 'status' => '1', 'preparation_time' => NULL, 'food_type' => 'others', 'price_type' => 'single', 'sales_price' => '370.00', 'images' => '["uploads\\/26\\/02\\/1770113008_6981c7f07c0b3.png"]', 'description' => NULL, 'meta' => NULL, 'created_at' => '2026-02-03 10:03:28', 'updated_at' => '2026-02-03 10:03:28'),
            array('productName' => 'Mixed Sweets', 'business_id' => '1', 'user_id' => '4', 'category_id' => '4', 'menu_id' => '5', 'status' => '1', 'preparation_time' => NULL, 'food_type' => 'others', 'price_type' => 'single', 'sales_price' => '210.00', 'images' => '["uploads\\/26\\/02\\/1770113283_6981c903cca75.png"]', 'description' => NULL, 'meta' => NULL, 'created_at' => '2026-02-03 10:08:03', 'updated_at' => '2026-02-03 10:08:03'),
            array('productName' => 'Gulab Jamun', 'business_id' => '1', 'user_id' => '4', 'category_id' => '4', 'menu_id' => '5', 'status' => '1', 'preparation_time' => NULL, 'food_type' => 'others', 'price_type' => 'single', 'sales_price' => '370.00', 'images' => '["uploads\\/26\\/02\\/1770113418_6981c98af2e3b.png"]', 'description' => NULL, 'meta' => NULL, 'created_at' => '2026-02-03 10:10:19', 'updated_at' => '2026-02-03 10:10:19')
        );

        Product::insert($products);

        $product_variations = array(
            array('product_id' => '1', 'name' => 'Small', 'price' => '220.00', 'created_at' => '2025-09-10 12:54:11', 'updated_at' => '2025-09-10 12:54:11'),
            array('product_id' => '1', 'name' => 'Large', 'price' => '340.00', 'created_at' => '2025-09-10 12:54:11', 'updated_at' => '2025-09-10 12:54:11'),
            array('product_id' => '3', 'name' => 'Medium', 'price' => '250.00', 'created_at' => '2025-09-10 13:27:46', 'updated_at' => '2025-09-10 13:27:46'),
            array('product_id' => '3', 'name' => 'Large', 'price' => '430.00', 'created_at' => '2025-09-10 13:27:46', 'updated_at' => '2025-09-10 13:27:46'),
            array('product_id' => '2', 'name' => 'Small', 'price' => '210.00', 'created_at' => '2025-09-10 13:32:04', 'updated_at' => '2025-09-10 13:32:04'),
            array('product_id' => '2', 'name' => 'Large', 'price' => '450.00', 'created_at' => '2025-09-10 13:32:04', 'updated_at' => '2025-09-10 13:32:04'),
            array('product_id' => '5', 'name' => 'Normal Glass', 'price' => '169.00', 'created_at' => '2025-09-10 15:22:21', 'updated_at' => '2025-09-10 15:22:21'),
            array('product_id' => '5', 'name' => 'Premium Glass', 'price' => '249.00', 'created_at' => '2025-09-10 15:22:21', 'updated_at' => '2025-09-10 15:22:21')
        );

        ProductVariation::insert($product_variations);
    }
}
