<?php

namespace Database\Seeders;

use App\Models\Currency;
use App\Models\UserCurrency;
use Illuminate\Database\Seeder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class CurrencySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        $currencies = [
            ['name' => 'Afghanistan Afghani', 'country_name' => 'Afghanistan', 'code' => 'AFN', 'rate' => 67.271, 'symbol' => '؋', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Albania Lek', 'country_name' => 'Albania', 'code' => 'ALL', 'rate' => 91.47, 'symbol' => 'L', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Algerian Dinar', 'country_name' => 'Algeria', 'code' => 'DZD', 'rate' => 133.08, 'symbol' => 'دج', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'US Dollar', 'country_name' => 'United States of America', 'code' => 'USD', 'rate' => 1, 'symbol' => '$', 'position' => 'left', 'status' => 1, 'is_default' => 1],
            ['name' => 'Angolan Kwanza', 'country_name' => 'Angola', 'code' => 'AOA', 'rate' => 910.982, 'symbol' => 'Kz', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Argentine Peso', 'country_name' => 'Argentina', 'code' => 'ARS', 'rate' => 1007.685, 'symbol' => '$', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Armenian Dram', 'country_name' => 'Armenia', 'code' => 'AMD', 'rate' => 389.25, 'symbol' => '֏', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Aruban Guilder', 'country_name' => 'Aruba', 'code' => 'AWG', 'rate' => 1.79, 'symbol' => 'ƒ', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Australian Dollar', 'country_name' => 'Australia', 'code' => 'AUD', 'rate' => 1.54, 'symbol' => '$', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Euro', 'country_name' => 'Austria', 'code' => 'EUR', 'rate' => 0.948, 'symbol' => '€', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Azerbaijan Manat', 'country_name' => 'Azerbaijan', 'code' => 'AZN', 'rate' => 1.699, 'symbol' => '₼', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Bahamian Dollar', 'country_name' => 'Bahamas', 'code' => 'BSD', 'rate' => 1, 'symbol' => '$', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Bahraini Dinar', 'country_name' => 'Bahrain', 'code' => 'BHD', 'rate' => 0.377, 'symbol' => '.د.ب', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Bangladesh Taka', 'country_name' => 'Bangladesh', 'code' => 'BDT', 'rate' => 119, 'symbol' => '৳', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Barbados Dollar', 'country_name' => 'Barbados', 'code' => 'BBD', 'rate' => 2, 'symbol' => '$', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Belarusian Ruble', 'country_name' => 'Belarus', 'code' => 'BYN', 'rate' => 3.427, 'symbol' => 'Br', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Belize Dollar', 'country_name' => 'Belize', 'code' => 'BZD', 'rate' => 2, 'symbol' => '$', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Bermuda Dollar', 'country_name' => 'Bermuda', 'code' => 'BMD', 'rate' => 1, 'symbol' => '$', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Bhutan Ngultrum', 'country_name' => 'Bhutan', 'code' => 'BTN', 'rate' => 84.45, 'symbol' => 'Nu.', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Bolivia Boliviano', 'country_name' => 'Bolivia', 'code' => 'BOB', 'rate' => 6.857, 'symbol' => 'Bs.', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Bosnia and Herzegovina Convertible Mark', 'country_name' => 'Bosnia and Herzegovina', 'code' => 'BAM', 'rate' => 1.854, 'symbol' => 'KM', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Botswana Pula', 'country_name' => 'Botswana', 'code' => 'BWP', 'rate' => 13.55, 'symbol' => 'P', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Brazilian Real', 'country_name' => 'Brazil', 'code' => 'BRL', 'rate' => 5.817, 'symbol' => 'R$', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Brunei Dollar', 'country_name' => 'Brunei', 'code' => 'BND', 'rate' => 1.342, 'symbol' => '$', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Bulgarian Lev', 'country_name' => 'Bulgaria', 'code' => 'BGN', 'rate' => 1.854, 'symbol' => 'лв', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Burundi Franc', 'country_name' => 'Burundi', 'code' => 'BIF', 'rate' => 2885.728, 'symbol' => 'FBu', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Cambodian Riel', 'country_name' => 'Cambodia', 'code' => 'KHR', 'rate' => 4017, 'symbol' => '៛', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Canadian Dollar', 'country_name' => 'Canada', 'code' => 'CAD', 'rate' => 1.405, 'symbol' => '$', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Cape Verde Escudo', 'country_name' => 'Cape Verde', 'code' => 'CVE', 'rate' => 104.497, 'symbol' => '$', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Cayman Is. Dollar', 'country_name' => 'Cayman Islands', 'code' => 'KYD', 'rate' => 0.82, 'symbol' => '$', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Chilean Peso', 'country_name' => 'Chile', 'code' => 'CLP', 'rate' => 973, 'symbol' => '$', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Chinese Renminbi', 'country_name' => 'China', 'code' => 'CNY', 'rate' => 7.245, 'symbol' => '¥', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Colombian Peso', 'country_name' => 'Colombia', 'code' => 'COP', 'rate' => 4413, 'symbol' => '$', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Comoros Franc', 'country_name' => 'Comoros', 'code' => 'KMF', 'rate' => 466.232, 'symbol' => 'CF', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Congo Franc, Dem. Rep.of', 'country_name' => 'Congo, Dem. Rep.', 'code' => 'CDF', 'rate' => 2843.075, 'symbol' => 'FC', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Costa Rica Colon', 'country_name' => 'Costa Rica', 'code' => 'CRC', 'rate' => 509.02, 'symbol' => '₡', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Cuban Peso', 'country_name' => 'Cuba', 'code' => 'CUP', 'rate' => 24, 'symbol' => '₱', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Czech Koruna', 'country_name' => 'Czech Republic', 'code' => 'CZK', 'rate' => 23.97, 'symbol' => 'Kč', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Danish Krone', 'country_name' => 'Denmark', 'code' => 'DKK', 'rate' => 7.068, 'symbol' => 'kr', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Djibouti Francs', 'country_name' => 'Djibouti', 'code' => 'DJF', 'rate' => 177, 'symbol' => 'Fdj', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'E.C. Dollar', 'country_name' => 'Anguilla', 'code' => 'XCD', 'rate' => 2.7, 'symbol' => '$', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Dominican Peso', 'country_name' => 'Dominican Republic', 'code' => 'DOP', 'rate' => 60.167, 'symbol' => 'RD$', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Egyptian Pound', 'country_name' => 'Egypt', 'code' => 'EGP', 'rate' => 49.61, 'symbol' => '£', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Eritrea Nakfa', 'country_name' => 'Eritrea', 'code' => 'ERN', 'rate' => 15, 'symbol' => 'Nfk', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Lilangeni', 'country_name' => 'Eswatini, Kingdom of', 'code' => 'SZL', 'rate' => 18.155, 'symbol' => 'E', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Ethiopian Birr', 'country_name' => 'Ethiopia', 'code' => 'ETB', 'rate' => 121.808, 'symbol' => 'Br', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Fiji Dollar', 'country_name' => 'Fiji', 'code' => 'FJD', 'rate' => 2.25, 'symbol' => '$', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Gambian Dalasi', 'country_name' => 'Gambia', 'code' => 'GMD', 'rate' => 70.409, 'symbol' => 'D', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Georgian Lari', 'country_name' => 'Georgia', 'code' => 'GEL', 'rate' => 2.743, 'symbol' => '₾', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Ghana Cedi', 'country_name' => 'Ghana', 'code' => 'GHS', 'rate' => 15.5, 'symbol' => '₵', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Gibraltar Pound', 'country_name' => 'Gibraltar', 'code' => 'GIP', 'rate' => 0.791, 'symbol' => '£', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Guatemala Quetzal(es)', 'country_name' => 'Guatemala', 'code' => 'GTQ', 'rate' => 7.709, 'symbol' => 'Q', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Guinean Franc', 'country_name' => 'Guinea', 'code' => 'GNF', 'rate' => 8552.17, 'symbol' => 'FG', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Guyana Dollar', 'country_name' => 'Guyana', 'code' => 'GYD', 'rate' => 207.9, 'symbol' => '$', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Haiti Gourde', 'country_name' => 'Haiti', 'code' => 'HTG', 'rate' => 130.93, 'symbol' => 'G', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Honduras Lempira', 'country_name' => 'Honduras', 'code' => 'HNL', 'rate' => 24.957, 'symbol' => 'L', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'HongKong Dollar', 'country_name' => 'Hong Kong', 'code' => 'HKD', 'rate' => 7.782, 'symbol' => 'HK$', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Hungary Forint', 'country_name' => 'Hungary', 'code' => 'HUF', 'rate' => 391.5, 'symbol' => 'Ft', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Iceland Krona', 'country_name' => 'Iceland', 'code' => 'ISK', 'rate' => 137.04, 'symbol' => 'kr', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Indian Rupee', 'country_name' => 'India', 'code' => 'INR', 'rate' => 84.45, 'symbol' => '₹', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Indonesia Rupiah', 'country_name' => 'Indonesia', 'code' => 'IDR', 'rate' => 15930, 'symbol' => 'Rp', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Iranian Rial', 'country_name' => 'Iran', 'code' => 'IRR', 'rate' => 512897, 'symbol' => '﷼', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Iraqi Dinar', 'country_name' => 'Iraq', 'code' => 'IQD', 'rate' => 1310, 'symbol' => 'ع.د', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Israel Shekel', 'country_name' => 'Israel', 'code' => 'ILS', 'rate' => 3.647, 'symbol' => '₪', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Jamaican Dollar', 'country_name' => 'Jamaica', 'code' => 'JMD', 'rate' => 157.347, 'symbol' => 'J$', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Japanese Yen', 'country_name' => 'Japan', 'code' => 'JPY', 'rate' => 151.42, 'symbol' => '¥', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Jordanian Dinar', 'country_name' => 'Jordan', 'code' => 'JOD', 'rate' => 0.708, 'symbol' => 'د.ا', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Kazakhstan Tenge', 'country_name' => 'Kazakhstan', 'code' => 'KZT', 'rate' => 502.23, 'symbol' => '₸', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Kenyan Shilling', 'country_name' => 'Kenya', 'code' => 'KES', 'rate' => 129, 'symbol' => 'KSh', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Korean Won, North Korea', 'country_name' => 'Korea, D.P.R. of', 'code' => 'KPW', 'rate' => 110, 'symbol' => '₩', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Korean Won, South Korea', 'country_name' => 'Korea, Republic of', 'code' => 'KRW', 'rate' => 1392.51, 'symbol' => '₩', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Kuwaiti Dinar', 'country_name' => 'Kuwait', 'code' => 'KWD', 'rate' => 0.31, 'symbol' => 'د.ك', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Kyrgyzstan Som', 'country_name' => 'Kyrgyzstan', 'code' => 'KGS', 'rate' => 86.25, 'symbol' => 'с', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Laos Kip', 'country_name' => "Lao, People's Dem. Rep.", 'code' => 'LAK', 'rate' => 22020, 'symbol' => '₭', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Lebanese Pound', 'country_name' => 'Lebanon', 'code' => 'LBP', 'rate' => 89500, 'symbol' => 'ل.ل', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Lesotho Loti', 'country_name' => 'Lesotho', 'code' => 'LSL', 'rate' => 18.155, 'symbol' => 'M', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Liberian Dollar', 'country_name' => 'Liberia', 'code' => 'LRD', 'rate' => 179.389, 'symbol' => '$', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Libyan Dinar', 'country_name' => 'Libyan Arab Jamahiriya', 'code' => 'LYD', 'rate' => 4.894, 'symbol' => 'د.ل', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Macao Pataca', 'country_name' => 'Macao', 'code' => 'MOP', 'rate' => 8.015, 'symbol' => 'P', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Malagasy Ariary', 'country_name' => 'Madagascar', 'code' => 'MGA', 'rate' => 4667.74, 'symbol' => 'Ar', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Malawi Kwacha', 'country_name' => 'Malawi', 'code' => 'MWK', 'rate' => 1751, 'symbol' => 'MK', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Malaysia Ringgit', 'country_name' => 'Malaysia', 'code' => 'MYR', 'rate' => 4.44, 'symbol' => 'RM', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Maldives Rufiyaa', 'country_name' => 'Maldives', 'code' => 'MVR', 'rate' => 15, 'symbol' => 'Rf', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Mauritania Ouguiya', 'country_name' => 'Mauritania', 'code' => 'MRU', 'rate' => 39.77, 'symbol' => 'UM', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Mauritius Rupee', 'country_name' => 'Mauritius', 'code' => 'MUR', 'rate' => 46.64, 'symbol' => '₨', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Mexican Peso', 'country_name' => 'Mexico', 'code' => 'MXN', 'rate' => 20.68, 'symbol' => '$', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Moldovan Leu', 'country_name' => 'Moldova, Republic of', 'code' => 'MDL', 'rate' => 18.225, 'symbol' => 'L', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Mongolia Tugrik', 'country_name' => 'Mongolia', 'code' => 'MNT', 'rate' => 3406, 'symbol' => '₮', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Morocco Dirham', 'country_name' => 'Morocco', 'code' => 'MAD', 'rate' => 10.004, 'symbol' => 'د.م.', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Mozambique Metical', 'country_name' => 'Mozambique', 'code' => 'MZN', 'rate' => 63.25, 'symbol' => 'MT', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Myanmar Kyat', 'country_name' => 'Myanmar', 'code' => 'MMK', 'rate' => 4100, 'symbol' => 'K', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Namibia Dollar', 'country_name' => 'Namibia', 'code' => 'NAD', 'rate' => 18.155, 'symbol' => 'N$', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Nepalese Rupee', 'country_name' => 'Nepal', 'code' => 'NPR', 'rate' => 135.109, 'symbol' => '₨', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Netherlands Antilles Guilder', 'country_name' => 'Netherlands Antilles', 'code' => 'ANG', 'rate' => 1.79, 'symbol' => 'ƒ', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'CFP Franc', 'country_name' => 'New Caledonia', 'code' => 'XPF', 'rate' => 113.089, 'symbol' => '₣', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'New Zealand Dollar', 'country_name' => 'New Zealand', 'code' => 'NZD', 'rate' => 1.694, 'symbol' => '$', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Nicaragua Cordoba Oro', 'country_name' => 'Nicaragua', 'code' => 'NIO', 'rate' => 36.55, 'symbol' => 'C$', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Nigeria Naira', 'country_name' => 'Nigeria', 'code' => 'NGN', 'rate' => 1680.29, 'symbol' => '₦', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Denar', 'country_name' => 'North Macedonia, Rep. of', 'code' => 'MKD', 'rate' => 58.11, 'symbol' => 'ден', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Norwegian Krone', 'country_name' => 'Norway', 'code' => 'NOK', 'rate' => 11.072, 'symbol' => 'kr', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Oman Rial', 'country_name' => 'Oman', 'code' => 'OMR', 'rate' => 0.385, 'symbol' => 'ر.ع.', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Pakistani Rupee', 'country_name' => 'Pakistan', 'code' => 'PKR', 'rate' => 277.771, 'symbol' => '₨', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Panama Balboa', 'country_name' => 'Panama', 'code' => 'PAB', 'rate' => 1, 'symbol' => 'B/.', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Kina', 'country_name' => 'Papua New Guinea', 'code' => 'PGK', 'rate' => 3.954, 'symbol' => 'K', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Paraguay Guarani', 'country_name' => 'Paraguay', 'code' => 'PYG', 'rate' => 7804, 'symbol' => '₲', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Sol', 'country_name' => 'Peru', 'code' => 'PEN', 'rate' => 3.758, 'symbol' => 'S/', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Philippine Peso', 'country_name' => 'Philippines', 'code' => 'PHP', 'rate' => 58.7, 'symbol' => '₱', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Poland Zloty', 'country_name' => 'Poland', 'code' => 'PLN', 'rate' => 4.079, 'symbol' => 'zł', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Qatari Rial', 'country_name' => 'Qatar', 'code' => 'QAR', 'rate' => 3.646, 'symbol' => 'ر.ق.', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Romanian Leu', 'country_name' => 'Romania', 'code' => 'RON', 'rate' => 4.715, 'symbol' => 'lei', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Russian Rouble', 'country_name' => 'Russian Federation', 'code' => 'RUB', 'rate' => 111.6, 'symbol' => '₽', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Rwanda Franc', 'country_name' => 'Rwanda', 'code' => 'RWF', 'rate' => 1360.482, 'symbol' => 'FRw', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'St. Helena Pound', 'country_name' => 'Saint Helena', 'code' => 'SHP', 'rate' => 0.791, 'symbol' => '£', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Samoa Tala', 'country_name' => 'Samoa', 'code' => 'WST', 'rate' => 2.752, 'symbol' => 'T', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Sao Tome Principe Dobra', 'country_name' => 'Sao Tome and Principe', 'code' => 'STN', 'rate' => 23.277, 'symbol' => 'Db', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Saudi Riyal', 'country_name' => 'Saudi Arabia', 'code' => 'SAR', 'rate' => 3.756, 'symbol' => 'ر.س.', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'CFA Franc', 'country_name' => 'Senegal', 'code' => 'XOF', 'rate' => 621.642, 'symbol' => 'Fr', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Serbian Dinar', 'country_name' => 'Serbia', 'code' => 'RSD', 'rate' => 110.802, 'symbol' => 'дин.', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Seychelles Rupee', 'country_name' => 'Seychelles', 'code' => 'SCR', 'rate' => 13.654, 'symbol' => '₨', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Sierra Leone Leone', 'country_name' => 'Sierra Leone', 'code' => 'SLE', 'rate' => 23.39, 'symbol' => 'Le', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Singapore Dollar', 'country_name' => 'Singapore', 'code' => 'SGD', 'rate' => 1.342, 'symbol' => '$', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Solomon Is. Dollar', 'country_name' => 'Solomon Islands', 'code' => 'SBD', 'rate' => 8.285, 'symbol' => '$', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Somali Shilling', 'country_name' => 'Somalia', 'code' => 'SOS', 'rate' => 24300, 'symbol' => 'S', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'South Africa Rand', 'country_name' => 'South Africa', 'code' => 'ZAR', 'rate' => 18.155, 'symbol' => 'R', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'South Sudanese Pound', 'country_name' => 'South Sudan', 'code' => 'SSP', 'rate' => 3613.144, 'symbol' => 'SSP', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Sri Lanka Rupee', 'country_name' => 'Sri Lanka', 'code' => 'LKR', 'rate' => 290.57, 'symbol' => 'Rs', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Sudanese Pound', 'country_name' => 'Sudan', 'code' => 'SDG', 'rate' => 1987, 'symbol' => 'ج.س.', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Surinamese Dollar', 'country_name' => 'Suriname', 'code' => 'SRD', 'rate' => 35.517, 'symbol' => '$', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Swedish Krona', 'country_name' => 'Sweden', 'code' => 'SEK', 'rate' => 10.918, 'symbol' => 'kr', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Swiss Franc', 'country_name' => 'Switzerland', 'code' => 'CHF', 'rate' => 0.882, 'symbol' => 'CHF', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Syrian Pound', 'country_name' => 'Syrian Arab Republic', 'code' => 'SYP', 'rate' => 13600, 'symbol' => '£S', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Tajikistan Somoni', 'country_name' => 'Tajikistan', 'code' => 'TJS', 'rate' => 10.67, 'symbol' => 'SM', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Tanzania Shilling', 'country_name' => 'Tanzania, United Rep. of', 'code' => 'TZS', 'rate' => 2640, 'symbol' => 'TSh', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Thai Baht', 'country_name' => 'Thailand', 'code' => 'THB', 'rate' => 34.43, 'symbol' => '฿', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Tonga Pa\'anga', 'country_name' => 'Tonga', 'code' => 'TOP', 'rate' => 2.346, 'symbol' => 'T$', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Trinidad and Tobago Dollar', 'country_name' => 'Trinidad and Tobago', 'code' => 'TTD', 'rate' => 6.754, 'symbol' => 'TT$', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Tunisian Dinar', 'country_name' => 'Tunisia', 'code' => 'TND', 'rate' => 3.146, 'symbol' => 'د.ت', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Turkish Lira', 'country_name' => 'Turkey', 'code' => 'TRY', 'rate' => 34.656, 'symbol' => '₺', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Turkmenistan Manat', 'country_name' => 'Turkmenistan', 'code' => 'TMT', 'rate' => 3.5, 'symbol' => 'm', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Uganda Shilling', 'country_name' => 'Uganda', 'code' => 'UGX', 'rate' => 3682, 'symbol' => 'Sh', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Ukraine Hryvnia', 'country_name' => 'Ukraine', 'code' => 'UAH', 'rate' => 41.5, 'symbol' => '₴', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'United Arab Emirates Dirham', 'country_name' => 'United Arab Emirates', 'code' => 'AED', 'rate' => 3.673, 'symbol' => 'د.إ', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'U.K. Pound', 'country_name' => 'United Kingdom', 'code' => 'GBP', 'rate' => 0.791, 'symbol' => '£', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Uruguay Peso', 'country_name' => 'Uruguay', 'code' => 'UYU', 'rate' => 42.87, 'symbol' => '$', 'position' => 'left', 'status' => 1, 'is_default' => 0],
            ['name' => 'Uzbekistan Sum', 'country_name' => 'Uzbekistan', 'code' => 'UZS', 'rate' => 12830, 'symbol' => 'сўм', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Vanuatu Vatu', 'country_name' => 'Vanuatu', 'code' => 'VUV', 'rate' => 117.74, 'symbol' => 'Vt', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Bolivar Digital', 'country_name' => 'Venezuela', 'code' => 'VES', 'rate' => 46.327, 'symbol' => 'Bs.S', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Viet Nam Dong', 'country_name' => 'Viet Nam', 'code' => 'VND', 'rate' => 25384, 'symbol' => '₫', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Yemeni Rial', 'country_name' => 'Yemen, Republic of', 'code' => 'YER', 'rate' => 528.74, 'symbol' => '﷼', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Zambia Kwacha', 'country_name' => 'Zambia', 'code' => 'ZMW', 'rate' => 27.324, 'symbol' => 'ZK', 'position' => 'right', 'status' => 1, 'is_default' => 0],
            ['name' => 'Zimbabwe Gold', 'country_name' => 'Zimbabwe', 'code' => 'ZWG', 'rate' => 25.333, 'symbol' => 'ZWL', 'position' => 'right', 'status' => 1, 'is_default' => 0]
        ];

        Currency::insert($currencies);

        $user_currencies = array(
             array('business_id' => '1','currency_id' => '4','name' => 'US Dollar','country_name' => 'United States of America','code' => 'USD','rate' => '1','symbol' => '$','position' => 'left','created_at' => '2025-11-13 00:40:16','updated_at' => '2025-11-13 00:40:16')
        );

        UserCurrency::insert($user_currencies);
    }
}
