<?php

namespace Database\Seeders;

use App\Models\Blog;
use Illuminate\Database\Seeder;

class BlogSeeder extends Seeder
{
    public function run(): void
    {
        $blogs = array(
            array('user_id' => '1', 'business_id' => NULL, 'title' => 'How to Streamline Billing in Your Restaurant', 'slug' => 'how-to-streamline-billing-in-your-restaurant', 'image' => 'uploads/25/06/1750759276-316.png', 'status' => '1', 'descriptions' => 'For restaurant owners, efficient billing is paramount to success. This topic explores practical strategies to optimize the entire billing process, from order placement to payment. It delves into implementing modern POS systems, integrating digital payment options, and training staff for accuracy and speed. By streamlining billing, restaurants can significantly reduce wait times, minimize errors, enhance customer satisfaction, and ultimately boost their bottom line through improved operational efficiency and faster table turnover. This approach fosters a smoother dining experience for customers and a more profitable operation for the business.', 'tags' => '["Food"]', 'meta' => '{"title":null,"description":null}', 'created_at' => '2025-06-24 16:01:16', 'updated_at' => '2025-06-24 16:01:16'),
            array('user_id' => '1', 'business_id' => NULL, 'title' => 'How We Craft the Perfect Burger (Behind the Scenes)', 'slug' => 'dfgdghow-we-craft-the-perfect-burger-behind-the-scenes', 'image' => 'uploads/25/06/1750759354-527.png', 'status' => '1', 'descriptions' => 'Promises an exclusive look into the meticulous process of creating an exceptional burger. It suggests that readers will go beyond the finished product, delving into the hidden steps, careful selections, and expert techniques that transform simple ingredients into a culinary masterpiece. From choosing the finest cuts of meat and freshest produce to the art of seasoning and grilling, this piece will reveal the dedication and passion behind every mouth-watering bite, offering insights usually reserved for the culinary elite.', 'tags' => '["Restaurant"]', 'meta' => '{"title":null,"description":null}', 'created_at' => '2025-06-24 16:01:16', 'updated_at' => '2025-06-24 16:01:16'),
            array('user_id' => '1', 'business_id' => NULL, 'title' => 'Top 5 Most Loved Items on Our Menu', 'slug' => 'top-5-most-loved-items-on-our-menu', 'image' => 'uploads/25/06/1750759390-584.png', 'status' => '1', 'descriptions' => 'Immediately captures attention by highlighting the most popular dishes. It piques curiosity, encouraging readers to discover what has earned such high praise from other customers. This list likely showcases signature dishes, fan favorites, or perhaps even unexpected delights that have become culinary sensations. It serves as an excellent guide for new patrons and a confirmation for regulars, inviting everyone to experience the best of what the establishment has to offer and understand why these specific items resonate so strongly with diners.', 'tags' => '["Dining"]', 'meta' => '{"title":null,"description":null}', 'created_at' => '2025-06-24 16:01:16', 'updated_at' => '2025-06-24 16:01:16'),
            array('user_id' => '1', 'business_id' => NULL, 'title' => 'Behind the Recipe: How We Make Our pizza', 'slug' => 'behind-the-recipe-how-we-make-our-pizza', 'image' => 'uploads/25/06/1750759421-24.png', 'status' => '1', 'descriptions' => 'How We Make Our Pizza," promises an exclusive glimpse into the culinary secrets behind their renowned pizza. It suggests a deep dive beyond just ingredients, exploring the precise techniques, unique preparation methods, and perhaps even the inspiration that defines their pizza\'s distinct flavor and texture. Readers can expect to learn about everything from the dough-making process and sauce preparation to the selection of toppings and baking methods. This behind-the-scenes narrative aims to enhance appreciation for the craftsmanship and passion poured into every slice.', 'tags' => '["Menu","Cuisine"]', 'meta' => '{"title":null,"description":null}', 'created_at' => '2025-06-24 16:01:16', 'updated_at' => '2025-06-24 16:01:16'),
            array('user_id' => '1', 'business_id' => NULL, 'title' => 'Fast Food Hacks You Didn\'t Know About', 'slug' => 'fast-food-hacks-you-didnt-know-about', 'image' => 'uploads/25/06/1750759458-857.png', 'status' => '1', 'descriptions' => 'Fast Food Hacks You Didn\'t Know About," immediately grabs attention by promising insider tips and clever tricks to enhance the fast-food experience. It suggests uncovering hidden menu items, ways to save money, optimize orders for freshness, or even customize meals in unexpected ways. This content aims to empower consumers, transforming their casual fast-food visits into more strategic and satisfying encounters. It taps into the universal desire for value and personalization, making everyday fast food more exciting and rewarding by revealing ingenious shortcuts and secrets.', 'tags' => '["Order","Delivery"]', 'meta' => '{"title":null,"description":null}', 'created_at' => '2025-06-24 16:01:16', 'updated_at' => '2025-06-24 16:01:16'),
            array('user_id' => '1', 'business_id' => NULL, 'title' => 'How to Join Our Loyalty Program and Earn Free Meals', 'slug' => 'how-to-join-our-loyalty-program-and-earn-free-meals', 'image' => 'uploads/25/06/1750759500-248.png', 'status' => '1', 'descriptions' => 'How to Join Our Loyalty Program and Earn Free Meals," is highly appealing to customers looking for value and rewards. It clearly outlines the benefit – free meals – and the path to achieving it – joining a loyalty program. This content would detail the simple steps for enrollment, explain how points or rewards are accrued with each purchase, and specify how these points can be redeemed. It effectively incentivizes repeat business by demonstrating a tangible benefit for customer loyalty, making the proposition attractive and straightforward for anyone interested in saving money on their favorite meals.', 'tags' => '["Reservation","Cafe","Aahar"]', 'meta' => '{"title":null,"description":null}', 'created_at' => '2025-06-24 16:01:16', 'updated_at' => '2025-06-24 16:01:16'),
        );

        Blog::insert($blogs);
    }
}
