<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->foreignId('business_id')->nullable()->constrained()->cascadeOnDelete();
            $table->string('email')->nullable()->unique();
            $table->string('name')->nullable();
            $table->string('role')->default('shop-owner'); // admin || shop-owner || staff
            $table->string('phone')->nullable();
            $table->string('image')->nullable();
            $table->string('lang')->nullable();
            $table->longText('visibility')->nullable();
            $table->string('password')->nullable();
            $table->string('status')->nullable(); // ative, pending
            $table->timestamp('email_verified_at')->nullable();
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
