<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PlanSubscribe extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'price',
        'notes',
        'plan_id',
        'duration',
        'gateway_id',
        'business_id',
        'payment_status',
        'addon_domain_limit',
        'subdomain_limit',
    ];

    public function plan() : BelongsTo
    {
        return $this->belongsTo(Plan::class);
    }

    public function business() : BelongsTo
    {
        return $this->belongsTo(Business::class);
    }

    public function gateway() : BelongsTo
    {
        return $this->belongsTo(Gateway::class);
    }

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'plan_id' => 'integer',
        'business_id' => 'integer',
        'gateway_id' => 'integer',
        'price' => 'double',
        'duration' => 'integer',
        'addon_domain_limit' => 'integer',
        'subdomain_limit' => 'integer',
        'notes' => 'json',
    ];
}
