<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use illuminate\Support\Str;

class Blog extends Model
{
    use HasFactory;

    protected $fillable = ['user_id', 'business_id', 'title', 'slug', 'image', 'status', 'descriptions', 'tags', 'meta'];

    protected $casts = [
        'user_id' => 'integer',
        'business_id' => 'integer',
        'tags' => 'json',
        'meta' => 'json',
        'status' => 'integer'
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($blog) {
            $blog->slug = Str::slug($blog->title);
        });
    }
}
