<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Symfony\Component\HttpFoundation\Response;

class DemoMode
{
    public function handle(Request $request, Closure $next): Response
    {
        if (env('DEMO_MODE', false)) {
            $adminDisabledRoutes = [
                'admin.blogs.delete-all',
                'admin.blogs.status',
                'admin.blogs.update',
                'admin.blogs.destroy',
                'admin.business-categories.delete-all',
                'admin.business-categories.status',
                'admin.business-categories.update',
                'admin.business-categories.destroy',
                'admin.business.delete-all',
                'admin.business.status',
                'admin.business.update',
                'admin.business.destroy',
                'admin.comments.delete-all',
                'admin.comments.destroy',
                'admin.currencies.delete-all',
                'admin.currencies.default',
                'admin.currencies.update',
                'admin.currencies.destroy',
                'admin.faqs.delete-all',
                'admin.faqs.status',
                'admin.faqs.update',
                'admin.faqs.destroy',
                'admin.features.delete-all',
                'admin.features.status',
                'admin.features.update',
                'admin.features.destroy',
                'admin.gateways.update',
                'admin.interfaces.delete-all',
                'admin.interfaces.status',
                'admin.interfaces.update',
                'admin.interfaces.destroy',
                'admin.manual-payments.paid',
                'admin.manual-payments.reject',
                'admin.messages.delete-all',
                'admin.messages.destroy',
                'admin.plans.delete-all',
                'admin.plans.popular',
                'admin.plans.status',
                'admin.plans.store',
                'admin.plans.update',
                'admin.plans.destroy',
                'admin.profiles.update',
                'admin.roles.update',
                'admin.roles.destroy',
                'admin.settings.update',
                'admin.subscription.paid',
                'admin.subscription.reject',
                'admin.testimonials.delete-all',
                'admin.testimonials.update',
                'admin.testimonials.destroy',
                'admin.users.delete-all',
                'admin.users.status',
                'admin.users.update',
                'admin.users.destroy',
                'admin.website-settings.update',
            ];

            $restaurantDisabledRoutes = [
                'categories.update',
                'categories.destroy',
                'coupons.update',
                'coupons.destroy',
                'delivery-address.update',
                'delivery-address.destroy',
                'expense-categories.update',
                'expense-categories.destroy',
                'expenses.update',
                'expenses.destroy',
                'income-categories.update',
                'income-categories.destroy',
                'incomes.update',
                'incomes.destroy',
                'ingredients.update',
                'ingredients.destroy',
                'menus.update',
                'menus.destroy',
                'modifier-groups.update',
                'modifier-groups.destroy',
                'modifiers.update',
                'modifiers.destroy',
                'parties.update',
                'parties.destroy',
                'payment-types.update',
                'payment-types.destroy',
                'products.update',
                'products.destroy',
                'purchase.update',
                'purchase.destroy',
                'quotations.update',
                'quotations.destroy',
                'role-permission.update',
                'role-permission.destroy',
                'sales.update',
                'sales.destroy',
                'staffs.update',
                'staffs.destroy',
                'tables.update',
                'tables.destroy',
                'taxes.update',
                'taxes.destroy',
                'units.update',
                'units.destroy',
                'users.update',
                'users.destroy',

                'business.areas.delete-all',
                'business.areas.update',
                'business.areas.destroy',
                'business.carts.update',
                'business.carts.destroy',
                'business.categories.delete-all',
                'business.categories.update',
                'business.categories.destroy',
                'business.coupons.delete-all',
                'business.coupons.update',
                'business.coupons.destroy',
                'business.currencies.default',
                'business.expense-categories.delete-all',
                'business.expense-categories.status',
                'business.expense-categories.update',
                'business.expense-categories.destroy',
                'business.expenses.delete-all',
                'business.expenses.update',
                'business.expenses.destroy',
                'business.income-categories.delete-all',
                'business.income-categories.status',
                'business.income-categories.update',
                'business.income-categories.destroy',
                'business.incomes.delete-all',
                'business.incomes.update',
                'business.incomes.destroy',
                'business.items.delete-all',
                'business.items.update',
                'business.items.destroy',
                'business.manage-settings.update',
                'business.manage-settings.destroy',
                'business.menus.delete-all',
                'business.menus.update',
                'business.menus.destroy',
                'business.modifier-groups.delete-all',
                'business.modifier-groups.update',
                'business.modifier-groups.destroy',
                'business.modifiers.delete-all',
                'business.modifiers.update',
                'business.modifiers.destroy',
                'business.parties.delete-all',
                'business.parties.update',
                'business.parties.destroy',
                'business.payment-types.delete-all',
                'business.payment-types.status',
                'business.payment-types.update',
                'business.payment-types.destroy',
                'business.products.delete-all',
                'business.products.variationDelete',
                'business.products.variationUpdate',
                'business.products.update',
                'business.products.destroy',
                'business.profiles.update',
                'business.purchases.delete-all',
                'business.purchases.update',
                'business.purchases.destroy',
                'business.quotations.delete-all',
                'business.quotations.update',
                'business.quotations.destroy',
                'business.roles.update',
                'business.roles.destroy',
                'business.sale-carts.update',
                'business.sale-carts.destroy',
                'business.sales.delete-all',
                'business.sales.status',
                'business.sales.update',
                'business.sales.destroy',
                'business.settings.update',
                'business.staffs.delete-all',
                'business.staffs.update',
                'business.staffs.destroy',
                'business.tables.delete-all',
                'business.tables.status',
                'business.tables.update',
                'business.tables.destroy',
                'business.units.delete-all',
                'business.units.status',
                'business.units.update',
                'business.units.destroy',
                'business.vats.deleteAll',
                'business.vats.status',
                'business.vats.vat-apply',
                'business.vats.update',
                'business.vats.destroy',
                'business.website-settings.update',
                'business.testimonials.update',
                'business.testimonials.destroy',
                'business.testimonials.delete-all',
                'business.blogs.update',
                'business.blogs.destroy',
                'business.blogs.delete-all',
                'business.roles.update',
                'business.roles.destroy',
            ];

            if (in_array(Route::currentRouteName(), $adminDisabledRoutes)) {
                return response()->json(['message' => 'This action is disabled in demo mode.'], 499);
            } elseif (auth()->check() && auth()->user()->business_id == 1 && in_array(Route::currentRouteName(), $restaurantDisabledRoutes)) {
                return response()->json(['message' => 'This action is disabled in demo account. Please sign up your own account for full access.'], 499);
            }
        }

        return $next($request);
    }
}
